// uctek.c   Unix console program.     Avoozl, [dOPEmAN], PoTom    1998-99 

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <termios.h>
#include <fcntl.h>
#include <unistd.h>
#include <time.h>
#include <signal.h>
#include <setjmp.h>
#include <ncurses.h>
#include "cteklib.h"
#include <term.h>
#include <ctype.h>
#include "uctek.h"
#include "u_global.h"

//    FUNCTIONS
int main(int argc,char *argv[])
{       
	bool status;
	int opt;
	while((opt=u_getopt(argc,argv,"thvp:")) != -1){
		switch(opt){
			case 't': S_TERM=TRUE; break;
			case 'p': strcpy(ttyport,optarg); break;
			case 'v': printf("UCTEK 0.99b2 (Beta 2, TERMIOS, NCURSES)\n");
			exit(0); break;
			case 'h':
			case '?':
			default :printf("\nUsage: %s	-p /dev/.. (to specify tty port)\n",argv[0]);
			printf("		-t        (simple terminal mode)\n");
				printf("		-v	  (shows version of program)\n");
				printf("		-h	  (for this usage message)\n");
				exit(0);
				break;
		}
	}					
	curses_setup();
	status=open_comport(ttyport);
	if(status==FALSE){
		err_cond=1;
		do_error();
	}
	signal_setup();
	init_oki_window();
	print_header();
	print_menu(0);
	menu_hint(0);
	do_about();
	menu();
}

void do_error(){
	char temp[45];
	OKI_DOWN=TRUE;
	if (err_cond == 1){
		sprintf(temp,"Error: could not open port %s.",ttyport);
		mvwaddstr(BODY,0,0,temp);
		if(strcmp(ttyport,"/dev/oki") == 0){
			mvwaddstr(BODY,1,0,"Make sure the symbolic link /dev/oki exists.");
			mvwaddstr(BODY,2,0,"If not type ln -s /dev/ttySX /dev/oki ,");
			mvwaddstr(BODY,3,0,"where X is dos COM port - 1.");
		}
		mvwaddstr(BODY,5,0,"If your phone connected to serial");
		mvwaddstr(BODY,6,0,"port which ussually used by mouse ,");
		mvwaddstr(BODY,7,0,"make sure you are not running 'gpm' and");
		mvwaddstr(BODY,8,0,"other mouse services such as Xwindows.");
		mvwaddstr(BODY,10,0,"Also make sure you have read/write");
		mvwaddstr(BODY,11,0,"permission for associated port, or run");
		mvwaddstr(BODY,12,0,"program as root.");
	}
	else {
		mvwaddstr(BODY,0,0,"Error: No response from OKI.         ");
		mvwaddstr(BODY,2,0,"Make sure connection is correct,");
		mvwaddstr(BODY,3,0,"Battery is charged or eliminator is on,");
		mvwaddstr(BODY,4,0,"and You using correct COM port.");
	}
	wrefresh(BODY);
	do_hint(NULL,"   Continue anyway [y/n] ?");
	if (toupper(wgetch(BODY)) == (int) 'N')
		exitprog(SIGINT);
	else {
		print_header();
		print_menu(0);
		menu_hint(0);
		do_about();
		menu();
	}
}	


void loopexit(int sig)
{
	signal(SIGINT,exitprog);
	do_hint(NULL,NULL);
	werase(MENU);
	wrefresh(MENU);
	print_menu(0);
	menu_hint(0);
	siglongjmp(breakloop,1);
}

void exitprog(int sig)
{
	clear(); 
	refresh();
	endwin();
	turn_off_oki();
	close_comport();
	printf("Thank You for Using our program.\n");
	printf("Please send comments and bug lists to:  potom@techfreakz.org\n");
	exit(0);
}

void do_hint(char *line1, char *line2)
{	
	werase(HINTBAR);
	mvwaddstr(HINTBAR,0,3,line1);
	mvwaddstr(HINTBAR,1,3,line2);
	wrefresh(HINTBAR);
}


void back_fvc(){
	get_fvc(OKI_FCC_ABORT,NULL);
	scanfcc(p_chan);
}

void read_nams()
{
	mvwaddstr(BODY,0,0,"Please Wait.. Reading NAMs..");
	wrefresh(BODY);      
	read_nam(&oki_nams[0],NAM1);
	read_nam(&oki_nams[1],NAM2);
	read_nam(&oki_nams[2],NAM3);
	read_nam(&oki_nams[3],NAM4);
	read_nam(&oki_nams[4],NAM5);
	mvwaddstr(BODY,0,0,"Please Wait.. Reading ESNs..");
	wrefresh(BODY);      
	read_esns(esn1,esn2,esn3,esn4,esn5);
	mvwaddstr(BODY,0,0,"	   Reading     DONE       ");
	wrefresh(BODY);
	sleep(1);
	mvwaddstr(BODY,0,0,"					");
	wrefresh(BODY);
}

void print_nams(int y, int x)
{ 
	char temp[100];
	
	mvwaddstr(BODY,2,0,"  MIN            ESN        SID    ");
	sprintf(temp,"(%s)%s-%s",oki_nams[0].areacode,oki_nams[0].prefix,oki_nams[0].number);
	mvwaddstr(BODY,4,0,temp);
	sprintf(temp,"(%s)%s-%s",oki_nams[1].areacode,oki_nams[1].prefix,oki_nams[1].number);
	mvwaddstr(BODY,6,0,temp);
	sprintf(temp,"(%s)%s-%s",oki_nams[2].areacode,oki_nams[2].prefix,oki_nams[2].number);
	mvwaddstr(BODY,8,0,temp);
	sprintf(temp,"(%s)%s-%s",oki_nams[3].areacode,oki_nams[3].prefix,oki_nams[3].number);
	mvwaddstr(BODY,10,0,temp);
	sprintf(temp,"(%s)%s-%s",oki_nams[4].areacode,oki_nams[4].prefix,oki_nams[4].number);
	mvwaddstr(BODY,12,0,temp);
	sprintf(temp,"%s",esn1);
	mvwaddstr(BODY,4,16,temp);
	sprintf(temp,"%s",esn2);
	mvwaddstr(BODY,6,16,temp);
	sprintf(temp,"%s",esn3);
	mvwaddstr(BODY,8,16,temp);
	sprintf(temp,"%s",esn4);
	mvwaddstr(BODY,10,16,temp);
	sprintf(temp,"%s",esn5); 
	mvwaddstr(BODY,12,16,temp);
	sprintf(temp,"%5.5d",oki_nams[0].sid); 
	mvwaddstr(BODY,4,27,temp);
	sprintf(temp,"%5.5d",oki_nams[1].sid); 
	mvwaddstr(BODY,6,27,temp);
	sprintf(temp,"%5.5d",oki_nams[2].sid); 
	mvwaddstr(BODY,8,27,temp);
	sprintf(temp,"%5.5d",oki_nams[3].sid); 
	mvwaddstr(BODY,10,27,temp);
	sprintf(temp,"%5.5d",oki_nams[4].sid); 
	mvwaddstr(BODY,12,27,temp);
	if (IS_COLORS){
		if(x==0)
			mvwchgat(BODY,4+2*y,0,13,A_BOLD,WHITE_BLUE,NULL);
		if(x==1)
			mvwchgat(BODY,4+2*y,16,8,A_BOLD,WHITE_BLUE,NULL);
		if(x==2)
			mvwchgat(BODY,4+2*y,27,5,A_BOLD,WHITE_BLUE,NULL);
	}
	else {
		if(x==0)
			mvwchgat(BODY,4+2*y,0,13,A_REVERSE,0,NULL);
		if(x==1)
			mvwchgat(BODY,4+2*y,16,8,A_REVERSE,0,NULL);
		if(x==2)
			mvwchgat(BODY,4+2*y,27,5,A_REVERSE,0,NULL);
	}
	wrefresh(BODY);
}

void write_nams()
{
	int z,x;
	streamlen=0;
	
	mvwaddstr(BODY,0,0,"Please Wait.. Writing NAMs..");
	wrefresh(BODY);      
	write_nam(oki_nams[0],NAM1);
	write_nam(oki_nams[1],NAM2);
	write_nam(oki_nams[2],NAM3);
	write_nam(oki_nams[3],NAM4);
	write_nam(oki_nams[4],NAM5);
	
	mvwaddstr(BODY,0,0,"Please Wait.. Writing ESNs..");
	wrefresh(BODY);      
	z=strlen(esn1);
	for(x=z;x<8;x++)
		esn1[x]='F';
	esn1[x]='\0';
	z=strlen(esn2);
	for(x=z;x<8;x++)
		esn2[x]='F';
	esn2[x]='\0';
	z=strlen(esn3);
	for(x=z;x<8;x++)
		esn3[x]='F';
	esn3[x]='\0';
	z=strlen(esn4);
	for(x=z;x<8;x++)
		esn4[x]='F';
	esn4[x]='\0';
	z=strlen(esn5);
	for(x=z;x<8;x++)
		esn5[x]='F';
	esn5[x]='\0';
	
	write_esns(esn1,esn2,esn3,esn4,esn5);
	mvwaddstr(BODY,0,0,"	   Writing	 DONE  ");
	wrefresh(BODY);
	sleep(2);
	mvwaddstr(BODY,0,0,"				");
	wrefresh(BODY);
	print_nams(0,0);
}

void print_header()
{
	mvwaddstr(HEADER,0,0," Unix CTEK - Beta 2              					Jan 1999");
	if (IS_COLORS)
		mvwchgat(HEADER,0,0,-1,A_BOLD,WHITE_BLUE,NULL);
	else
		mvwchgat(HEADER,0,0,-1,A_REVERSE,0,NULL);
	wrefresh(HEADER);
}

void menu()
{ 
	int done=0,pos,pos1, result,limit=11;
	char temp[20];
	pos=pos1=0;
	
	print_menu(0);
	menu_hint(0);
	cbreak();	
	keypad(MENU,TRUE);
	while(!done)
	{
		result=wgetch(MENU);
		if(result==KEY_UP)
		{
			if(pos!=0)
			{
				print_menu(--pos);
				menu_hint(--pos1);
			}
			else
			{
				pos=pos1=limit;
				print_menu(pos);
				menu_hint(pos1);
			}
		}            
		if(result==KEY_LEFT)
		{
			if(pos!=0)
			{
				print_menu(--pos);
				menu_hint(--pos1);
			}
			else
			{
				pos=pos1=limit;
				print_menu(pos);
				menu_hint(pos1);
			}
		}            
		if(result==KEY_DOWN)      
		{   
			if(pos!=limit)
			{
				print_menu(++pos);
				menu_hint(++pos1);
			}
			else
			{
				pos=pos1=0;
				print_menu(pos);
				menu_hint(pos1);
			}
		}
		if(result==KEY_RIGHT)      
		{   
			if(pos!=limit)
			{
				print_menu(++pos);
				menu_hint(++pos1);
			}
			else
			{
				pos=pos1=0;
				print_menu(pos);
				menu_hint(pos1);
			}
		}
		if(result==13)
			call_menu_func(pos);	       
	}
}

void print_menu(int y)
{
	
	mvwaddstr(MENU,0,0, "  OKI 900 MENU ");
	mvwaddstr(MENU,2,0, "     edit nams ");
	mvwaddstr(MENU,3,0, "     phonebook ");
	mvwaddstr(MENU,4,0, "    phone info ");
	mvwaddstr(MENU,5,0, "      view fcc ");
	mvwaddstr(MENU,6,0, "          scan ");
	mvwaddstr(MENU,7,0, "      fcc scan ");
	mvwaddstr(MENU,8,0, "  track min(s) ");
	mvwaddstr(MENU,9,0, "   find towers ");
	mvwaddstr(MENU,10,0,"  dischrg batt ");
	mvwaddstr(MENU,11,0,"          help ");
	mvwaddstr(MENU,12,0,"         about ");
	mvwaddstr(MENU,13,0,"          exit ");
	if (IS_COLORS){
		mvwchgat(MENU,0,0,-1,A_BOLD,WHITE_BLACK,NULL);
		mvwchgat(MENU,2,0,-1,A_BOLD,GREY_BLACK,NULL);
		mvwchgat(MENU,3,0,-1,A_BOLD,GREY_BLACK,NULL);
		mvwchgat(MENU,4,0,-1,A_BOLD,GREY_BLACK,NULL);
		mvwchgat(MENU,5,0,-1,A_BOLD,GREY_BLACK,NULL);
		mvwchgat(MENU,6,0,-1,A_BOLD,GREY_BLACK,NULL);
		mvwchgat(MENU,7,0,-1,A_BOLD,GREY_BLACK,NULL);
		mvwchgat(MENU,8,0,-1,A_BOLD,GREY_BLACK,NULL);
		mvwchgat(MENU,9,0,-1,A_BOLD,GREY_BLACK,NULL);
		mvwchgat(MENU,10,0,-1,A_BOLD,GREY_BLACK,NULL);
		mvwchgat(MENU,11,0,-1,A_BOLD,GREY_BLACK,NULL);
		mvwchgat(MENU,12,0,-1,A_BOLD,GREY_BLACK,NULL);
		mvwchgat(MENU,13,0,-1,A_BOLD,GREY_BLACK,NULL);
		mvwchgat(MENU,y+2,0,-1,A_BOLD,WHITE_BLACK,NULL);
	}
	else {
		mvwchgat(MENU,0,0,-1,A_BOLD,0,NULL);
		mvwchgat(MENU,y+2,0,-1,A_REVERSE,0,NULL);
	}
	wrefresh(MENU);
	
}

void signal_setup()
{
// Setup Signals
	
   // signal(SIGHUP,exitprog);
	signal(SIGINT,exitprog);
	signal(SIGQUIT,exitprog);
   // signal(SIGILL,exitprog);
   // signal(SIGABRT,exitprog);
	signal(SIGFPE,exitprog);
	signal(SIGKILL,exitprog);
	signal(SIGSEGV,exitprog);
   // signal(SIGPIPE,exitprog);
	signal(SIGTERM,exitprog);
   // signal(SIGUSR1,exitprog);
   // signal(SIGUSR2,exitprog);
   // signal(SIGCHLD,exitprog);
   // signal(SIGSTOP,exitprog);
   // signal(SIGTSTP,exitprog);
   // signal(SIGTTIN,exitprog);
   // signal(SIGTTOU,exitprog);
   // signal(SIGTRAP,exitprog);
   // signal(SIGIOT,exitprog);
   // signal(SIGBUS,exitprog);
   // signal(SIGSTKFLT,exitprog);
   // signal(SIGURG,exitprog);
   // signal(SIGPOLL,exitprog);
   // signal(SIGXCPU,exitprog);
   // signal(SIGXFSZ,exitprog);
   // signal(SIGPROF,exitprog);
   // signal(SIGPWR,exitprog);
   // signal(SIGWINCH,exitprog);
}

void curses_setup() {
	
	initscr();
	if(has_colors() && !S_TERM){
		IS_COLORS=TRUE;
		start_color();
	}
	nonl();
	refresh();
	curs_set(0);
	MENUM =newwin(20,17,1,0);
	if (!S_TERM)
		box(MENUM,ACS_VLINE,ACS_HLINE);
	else
		mvwvline(MENUM,0,16,'|',LINES-4);
	
	wrefresh(MENUM);
	MENU = subwin(MENUM,20-2,17-2,1+1,0+1);
	noecho();
	BODYM =newwin(20,62,1,18);
	if (!S_TERM)
		box(BODYM,ACS_VLINE,ACS_HLINE);
	wrefresh(BODYM);
	BODY = subwin(BODYM,20-2,62-2,1+1,18+1);
	HEADER = newwin(1,80,0,0);
	HINTBARM = newwin(4,80,LINES-4,0);
	if (!S_TERM)
		box(HINTBARM,ACS_VLINE,ACS_HLINE);
	else
		mvwhline(HINTBARM,0,0,'_',COLS-1);
	
	wrefresh(HINTBARM);
	HINTBAR= subwin(HINTBARM,4-2,80-2,LINES-4+1,0+1);
	scrollok(BODY,1);
	if(IS_COLORS){
		init_pair(WHITE_BLUE, COLOR_WHITE, COLOR_BLUE);
		init_pair(CYAN_BLUE, COLOR_CYAN, COLOR_BLUE);
		init_pair(BLACK_BLUE, COLOR_BLACK, COLOR_BLUE);
		init_pair(RED_BLACK, COLOR_RED, COLOR_BLACK);
		init_pair(BLUE_BLACK, COLOR_BLUE, COLOR_BLACK);
		init_pair(GREY_BLACK, COLOR_BLACK, COLOR_BLACK);
		init_pair(WHITE_BLACK, COLOR_WHITE, COLOR_BLACK);
		init_pair(YELLOW_BLACK, COLOR_YELLOW, COLOR_BLACK);
		init_pair(GREEN_BLACK, COLOR_GREEN, COLOR_BLACK);
		
		wattrset(HINTBAR,A_BOLD|COLOR_PAIR(YELLOW_BLACK));
	}
	else 
		wattrset(HINTBAR,A_BOLD);	
}

void init_oki_window() 
{
	
	mvwaddstr (BODY,0,0,"Please Wait.. Initializing OKI..");
	wrefresh(BODY);
	
	signal(SIGALRM,do_error);
	alarm(6);
	initialize_oki(OKI_MODE_TEST);
	alarm(0);
	
	werase(BODY);
	wrefresh(BODY);
	
}

void menu_hint(int menunum)
{
	if (menunum == 0)
		do_hint(NULL,"Modify NAM/ESN pairs in phone. (4712 Firmware only)");	
	if (menunum == 1)
		do_hint(NULL,"View and Edit phonebook data in phone");
	if (menunum == 2)
		do_hint(NULL,"View and Edit user options in phone");
	if (menunum == 3)
		do_hint(NULL,"Monitor closest Forward Control Channel activity");
	if (menunum == 4)
		do_hint(NULL,"Scan channels for active calls");
	if (menunum == 5)
		do_hint(NULL,"Monitor closest FCC and listen originated calls"); 
	if (menunum == 6)
		do_hint(NULL,"Scan closest FCC and monitor only MINs specified"); 
	if (menunum == 7)
		do_hint(NULL,"View FCC signal strenght for identifing locations of cell towers");     	
	if (menunum == 8)
		do_hint(NULL,"View battery meter, discharge battery");
	if (menunum == 9)
		do_hint(NULL,"Displays help on menu items ");
	if (menunum == 10)
		do_hint(NULL,"About this program");
	if (menunum == 11)
		do_hint(NULL,"Turn Off phone  and  exit program");
}
void call_menu_func(int menunum)
{
	
	if (menunum == 0)
		edit_nams();
	if (menunum == 1)
		not_yet();
	if (menunum == 2)
		phone_info(0);
	if (menunum == 3)
		view_fcc();
	if (menunum == 4)
		not_yet();
	if (menunum == 5)
		scanfcc(0);
	if (menunum == 6)
		not_yet();
	if (menunum == 7) 
		find_towers();
	if (menunum == 8) 
		u_discharge_battery();
	if (menunum == 9) 
		display_help();
	if (menunum == 10)
		do_about();
	if (menunum == 11) 
		exitprog(0);
	menu();	
	
}

void edit_nams()
{
	int done=0,posx,posy,result;
	int limity=4,limitx=2;
	char tempvals[10][100];
	char temp[100];
	posx=posy=0;
	
	werase(BODY);
	read_nams();
	print_nams(0,0);
	do_hint("		Q - Menu    W - Write Nams     ","[ENTER] to edit field, [ENTER] when done, Arrows keys to move");
	if(IS_COLORS)	
		mvwchgat(BODY,2,6,-1,A_BOLD,WHITE_BLUE,NULL);
	else 
		mvwchgat(BODY,2,6,-1,A_REVERSE,0,NULL);
	keypad(BODY,TRUE);
	wmove(BODY,4,0);
	while(!done)
	{
		
		result=wgetch(BODY);
		if(result==KEY_DOWN)      
		{
			if(posy<limity)
				print_nams(++posy,posx);
			else {
				posy=0;
				print_nams(posy,posx);
			}
		}
		if(result==KEY_RIGHT)
		{
			if(posx<limitx)
				print_nams(posy,++posx);
			else {
				posx=0;
				print_nams(posy,posx);
			}
		}
		if(result==KEY_UP) 
		{
			if(posy>0)
				print_nams(--posy,posx);
			else {
				posy=limity;
				print_nams(posy,posx);
			}
		}
		if(result==KEY_LEFT)
		{
			if(posx>0)
				print_nams(posy,--posx);
			else {
				posx=limitx;
				print_nams(posy,posx);
			}
		}
		if(result==(int)'w' || result == (int)'W')      
		{
			write_nams();
		}
		if(result==(int)'q' || result == (int)'Q')      
		{
			do_hint(NULL,NULL);
			done=1;
		}
		if(result==13)      
		{
			select_nam(posy,posx);
		}
		if(result==27) 
		{
			done=1;
		}
		
	}
	werase(BODY);
	wrefresh(BODY);
}

void u_discharge_battery()
{
	int result;
	float volts;
	int level,cnt;
	char temp[100],scale[8];
	do_hint("		Q - Menu	D - Discharge		",NULL);
	werase(BODY);
	nodelay(BODY,TRUE);
	for(;;){
		level=get_battery_level(&volts);
		strcpy(scale,"        ");
		for (cnt=level;cnt > 0;cnt --)
			scale[cnt-1]='+';
		sprintf(temp,"Battery Power: %2.2f volts, level: %d [%s]",volts,level,scale);
		mvwaddstr(BODY,0,0,temp);
		wrefresh(BODY);
		sleep(2);
		result=wgetch(BODY);
		if(toupper(result)== (int)'Q')
			break;
		else if(toupper(result) == (int)'D') {
				ct_battery_discharge(ON);
			for(;;){
				result=wgetch(BODY);
				if (toupper(result) == (int)'Q')
					goto backm;
				level=get_battery_level(&volts);
				if (volts < 0){
					werase(BODY);
					mvwaddstr(BODY,0,0,"Battery is discharged,	You should exit program now.		");
					nodelay(BODY,FALSE);
					wrefresh(BODY);
					turn_off_oki();
					OKI_DOWN=TRUE;
					return;
				}
				strcpy(scale,"        ");
				for(cnt=level;cnt > 0; cnt--)
					scale[cnt-1]='+';
				sprintf(temp,"Battery Power: %2.2f volts,level: %d [%s]	                ",volts,level,scale);        
				mvwaddstr(BODY,0,0,temp);
				mvwaddstr(BODY,1,0,"DISCHARGING");
				mvwchgat(BODY,1,0,-1,A_BOLD|A_BLINK,0,NULL);
				wrefresh(BODY);
				sleep(2);
			}
		}
	}	
	backm:	
	ct_battery_discharge(OFF); 
	nodelay(BODY,FALSE);
	werase(BODY);
	wrefresh(BODY);
	
	
}

void print_info(int y){
	char temp[100];
	int diff;
	
	mvwaddstr(BODY,1,1,"Rom Version:");
	mvwaddstr(BODY,2,1,"Unlock Password:");
	mvwaddstr(BODY,2,40,"( 1-8 digits )");
	mvwaddstr(BODY,3,1,"Dealer Password:");
	mvwaddstr(BODY,3,40,"(10 digits only)");
	mvwaddstr(BODY,4,1,"Adm.Menu Password:");
	mvwaddstr(BODY,4,40,"( 6 digits only)");
	mvwaddstr(BODY,5,1,"Custom Message:");
	mvwaddstr(BODY,5,40,"(1-8 AlphaNumeric)");
	sprintf(temp,"%s",ver);
	mvwaddstr(BODY,1,20,temp);
	for(diff=0;diff < 8;diff++){
		if (KeyPass[diff] == '\0') KeyPass[diff]=' ';
	}
	KeyPass[8]='\0';
	sprintf(temp,"%s",KeyPass);
	mvwaddstr(BODY,2,20,temp);
	sprintf(temp,"%s",DealerPass);
	mvwaddstr(BODY,3,20,temp);
	sprintf(temp,"%s",AdmPass);
	mvwaddstr(BODY,4,20,temp);
	for (diff=0;diff < 8;diff++){
		if (message[diff]== '\0') message[diff]=' ';
	}
	sprintf(temp,"%s",message);
	mvwaddstr(BODY,5,20,temp);
	if (IS_COLORS){
		if (y==2)  	mvwchgat(BODY,2,20,8,A_BOLD,WHITE_BLUE,NULL);
		if (y==3)	mvwchgat(BODY,3,20,10,A_BOLD,WHITE_BLUE,NULL);
		if (y==4)	mvwchgat(BODY,4,20,6,A_BOLD,WHITE_BLUE,NULL);
		if (y==5)	mvwchgat(BODY,5,20,8,A_BOLD,WHITE_BLUE,NULL);
	}
	else{
		if (y==2)	mvwchgat(BODY,2,20,8,A_REVERSE,0,NULL);
		if (y==3)       mvwchgat(BODY,3,20,10,A_REVERSE,0,NULL);
		if (y==4)       mvwchgat(BODY,4,20,6,A_REVERSE,0,NULL);
		if (y==5)       mvwchgat(BODY,5,20,8,A_REVERSE,0,NULL);
	}
	wrefresh(BODY);
}


void phone_info(bool again)
{
	int y,x,z;
	char temp[100];
	int result;
	
	werase(BODY);
	waddstr(BODY,"Please Wait, Reading...");
	wrefresh(BODY);
	get_romversion(ver);
	bzero(message,sizeof(message));
	get_custom_msg(message);
	bzero(KeyPass,sizeof(KeyPass));
	keylock_pass(GET,KeyPass);
	dealer_pass(GET,DealerPass);
	adm_pass(GET,AdmPass);
	
	werase(BODY);
	wrefresh(BODY);
	do_hint("	Q - Menu	W - Write	R - Reread","Arrow keys to select field, [ENTER] to edit , [ENTER] when done");
	print_info(2);
	if (!again){
		nodelay(BODY,TRUE);
		keypad(BODY,TRUE);
		for (y=2;;){
			result=wgetch(BODY);
			if (result == KEY_DOWN) {
				y++;
				if (y==6) y=2;
			}
			if (result == KEY_UP) {
				y--;
				if (y==1) y=5;
			}
			if (toupper(result) == (int)'Q') {
				werase(BODY);
				wrefresh(BODY);
				return;
			}
			if (toupper(result) == (int)'R') {
				phone_info(TRUE);
			}
			if (toupper(result) == (int)'W') {
				mvwaddstr(BODY,0,0,"Please Wait, Writing....");
				wrefresh(BODY);
				keylock_pass(PUT,KeyPass);
				dealer_pass(PUT,DealerPass);
				adm_pass(PUT,AdmPass);
				set_custom_msg(message);
				sleep(2);
				mvwaddstr(BODY,0,0,"                          ");
				wrefresh(BODY);
			}
			if (result == 13) {
				mvwaddstr(BODY,y,20,"          ");
				nodelay(BODY,FALSE);
				if(y==2) z=8;
				if(y==3) z=10;
				if(y==4) z=6;
				if(y==5) z=8;
				if (IS_COLORS)
					mvwchgat(BODY,y,20,z,A_BOLD,WHITE_BLUE,NULL);
				else 
					mvwchgat(BODY,y,20,z,A_REVERSE,0,NULL);
				for(x=0;;){
					result=wgetch(BODY);
					if( y == 5 && (isalnum(result) || result == ' ')){
						if (x != z){
							temp[x]=(char)toupper(result);
							mvwaddch(BODY,y,20+x,temp[x]);
							if(IS_COLORS)
								mvwchgat(BODY,y,20+x,1,A_BOLD,WHITE_BLUE,NULL);
							else
								mvwchgat(BODY,y,20+x,1,A_REVERSE,0,NULL);
							x++;
						}
					}
					
					else if(isdigit(result)){
						if (x != z){
							temp[x]=(char)toupper(result);
							mvwaddch(BODY,y,20+x,temp[x]);
							if (IS_COLORS)
								mvwchgat(BODY,y,20+x,1,A_BOLD,WHITE_BLUE,NULL);
							else
								mvwchgat(BODY,y,20+x,1,A_REVERSE,0,NULL);
							x++;
						}
					}
					else if(result == 13) break;
				}
				temp[x]='\0';
				if(y==2 && x > 0){
					bzero(KeyPass,sizeof(KeyPass)); 
					strcpy(KeyPass,temp);
				}
				if(y==3 && x==10) strcpy(DealerPass,temp);
				if(y==4 && x==6)  strcpy(AdmPass,temp);
				if(y==5 && x >0) {
					bzero(message,sizeof(message));
					strcpy(message,temp);
				}
				nodelay(BODY,TRUE);
			}
			print_info(y);
		}
		nodelay(BODY,FALSE);
	}
	
}

void select_nam(int y,int x)
{
	int z=0,result,done=0,donea=0,q=0;
	int xcoord,ycoord;
	int xcoord2,ycoord2;
	char temp[20];
	
	getyx(BODY,ycoord2,xcoord2);
	
	switch (x){
		case 0:
			mvwaddstr(BODY,4+2*y,0,"(   )   -    ");
			if (IS_COLORS)
				mvwchgat(BODY,4+2*y,0,13,A_BOLD,WHITE_BLUE,NULL);
			else 
				mvwchgat(BODY,4+2*y,0,13,A_REVERSE,0,NULL);
			z=1;
			break;
			
		case 1:
			mvwaddstr(BODY,4+2*y,16,"        ");
			if (IS_COLORS)
				mvwchgat(BODY,4+2*y,16,8,A_BOLD,WHITE_BLUE,NULL);
			else
				mvwchgat(BODY,4+2*y,16,8,A_REVERSE,0,NULL);
			break;
			
		case 2:
			mvwaddstr(BODY,4+2*y,27,"     ");
			if (IS_COLORS)
				mvwchgat(BODY,4+2*y,27,5,A_BOLD,WHITE_BLUE,NULL);
			else
				mvwchgat(BODY,4+2*y,27,5,A_REVERSE,0,NULL);
			break;
	}
	
	
	
	wrefresh(BODY);
	while(!done)
	{
		result=wgetch(BODY);
		if(result==13)
			done=1;
		else if(result==KEY_BACKSPACE)
		{
			getyx(BODY,ycoord,xcoord);
			if(z==0)
				z=q+1;
			if(--z-q>0)
				temp[z-q]=' ';
			else
				temp[0]=' ';
			if(z>1) {
				if(q==2 && z==9) {
					mvwaddch(BODY,ycoord,z+xcoord,(char)' ');
					mvwaddch(BODY,ycoord,z+xcoord-1,(char)'-');
					q=1;
					if(x==0)
						z-=1;
				}
				else if(q==1 && z==5) {
					mvwaddch(BODY,ycoord,z+xcoord,(char)' ');
					mvwaddch(BODY,ycoord,z+xcoord-1,(char)')');
					q=0;
					if(x==0)
						z-=1;
				}
				else
				{
					mvwaddch(BODY,ycoord,z+xcoord,(char)' ');
					mvwaddch(BODY,ycoord,z+xcoord-1,temp[z-q-1]);
				}
				temp[z-q]='\0';
			}
			else if(z==1) {
				if(x==0) {
					mvwaddch(BODY,ycoord,1,' ');
					mvwaddch(BODY,ycoord,0,'(');
					z=1;
					q=0;
				}
				else
				{
					mvwaddch(BODY,ycoord,z+xcoord,(char)' ');
					mvwaddch(BODY,ycoord,z+xcoord-1,temp[z-1]);
				}
				temp[0]='\0';
			}	
			else if(z==0) {
				if(x==0) {
					mvwaddch(BODY,ycoord,0,'(');
					z=1;
					q=0;
				}
				else {
					mvwaddch(BODY,ycoord,xcoord,' ');
					z=0;
					q=0;
				}
				temp[0]='\0';
			}	
			if(z<0)
				z=0;
			donea=0;
		}
		else if(isxdigit(result) || result=='(' || result==')' || result=='-')
		{
			z++;
			if(x==0) {
				if(result=='(' || result==')' || result=='-')
					if(z!=1 || z!=5 || z!=9) {
						z--;
						result=0;
						continue;
					}
				if(z==1)
					z++;
				mvwaddch(BODY,ycoord2,0,(char)'(');
				if(z==5) { 
					if(result!=')') {
						mvwaddch(BODY,ycoord2,z+xcoord2-1,(char)')');
						z++;
					}
					q=1;
				}
				if(z==9) {
					if(result!='-') {
						mvwaddch(BODY,ycoord2,z+xcoord2-1,(char)'-');
						z++;
					}
					q=2;
				}
				if(z>13) {
					z=13;
					donea=1;
				}
			}
			if(x==1)
				if(z>8) {
					z=8;
					donea=1;
				}
			if(x==2)
				if(z>5) {
					z=5;
					donea=1;
				}
			if(!donea) 
			{
				if(isxdigit(result)) {
					temp[z-1-q]=(char)toupper(result); 
					mvwaddch(BODY,ycoord2,z+xcoord2-1,temp[z-1-q]);
				}
				else
					if(x==0)
						mvwaddch(BODY,ycoord2,z+xcoord2-1,(char)result);
					else
						z--;
			}
		}
		if(x==0) 
			if (IS_COLORS)
				mvwchgat(BODY,ycoord2,0,13,A_BOLD,WHITE_BLUE,NULL);
			else
				mvwchgat(BODY,ycoord2,0,13,A_REVERSE,0,NULL);
		if(x==1)
			if (IS_COLORS)
				mvwchgat(BODY,ycoord2,16,8,A_BOLD,WHITE_BLUE,NULL);
			else
				mvwchgat(BODY,ycoord2,16,8,A_REVERSE,0,NULL);
		if(x==2)
			if (IS_COLORS)
				mvwchgat(BODY,ycoord2,27,5,A_BOLD,WHITE_BLUE,NULL);
			else
				mvwchgat(BODY,ycoord2,27,5,A_REVERSE,0,NULL);
		wrefresh(BODY);
	} 
	temp[z]='\0';
	if(x==0)
	{
		if(strlen(temp)<10)
		{
			print_nams(y,x);
			return;
		}
		oki_nams[y].areacode[0]=temp[1];
		oki_nams[y].areacode[1]=temp[2];
		oki_nams[y].areacode[2]=temp[3];
		oki_nams[y].areacode[3]='\0';
		oki_nams[y].prefix[0]=temp[4];
		oki_nams[y].prefix[1]=temp[5];
		oki_nams[y].prefix[2]=temp[6];
		oki_nams[y].prefix[3]='\0';
		oki_nams[y].number[0]=temp[7];
		oki_nams[y].number[1]=temp[8];
		oki_nams[y].number[2]=temp[9];
		oki_nams[y].number[3]=temp[10];
		oki_nams[y].number[4]='\0';
		print_nams(y,x);
	}
	if(x==1)
	{
		z=strlen(temp);
		if(z<8)
		{
			print_nams(y,x);
			return;
		}
		if(y==0) 
			sprintf(esn1,"%s",temp);
		if(y==1) 
			sprintf(esn2,"%s",temp);
		if(y==2) 
			sprintf(esn3,"%s",temp);
		if(y==3) 
			sprintf(esn4,"%s",temp);
		if(y==4) 
			sprintf(esn5,"%s",temp);
		print_nams(y,x);
	}  
	if(x==2)
	{
		if(strlen(temp)<5)
		{
			print_nams(y,x);
			return;
		}
		for(x=0;x<5;x++)
			if(temp[x] > '9')
			{
				print_nams(y,x);
				return;
			}
		oki_nams[y].sid = (temp[0]-48)*10000+(temp[1]-48)*1000+(temp[2]-48)*100+(temp[3]-48)*10+temp[4]-48;
		print_nams(y,x);
	}
}

void display_help()
{
	int x=3,result,done=0;
	
	werase(BODY);
	mvwaddstr(BODY,0,0,"For a more help please read documentation");
	mvwaddstr(BODY,x++,0,"edit nams       - Edits the MIN, SID, and ESN (4712 only)");
	mvwaddstr(BODY,x++,0,"phonebook       - Edits the Memory Locations");
	mvwaddstr(BODY,x++,0,"phone info      - Displays the ROM Version, Minutes Used ");
	mvwaddstr(BODY,x++,0,"                  and other information");
	mvwaddstr(BODY,x++,0,"view fcc        - Dumps a Forward Control Channel to the");
	mvwaddstr(BODY,x++,0,"                  screen");
	mvwaddstr(BODY,x++,0,"scan            - Scan audio channels for conversations");
	mvwaddstr(BODY,x++,0,"fcc scan        - Listens to the Forward Control Channel");
	mvwaddstr(BODY,x++,0,"                  a setup, then tunes to that channel");
	mvwaddstr(BODY,x++,0,"track min(s)    - Track usage of certian Mobile ID");
	mvwaddstr(BODY,x++,0,"                  Numbers.");
	mvwaddstr(BODY,x++,0,"find towers     - Locate Cellular Towers, and create a  ");
	mvwaddstr(BODY,x++,0,"                  log of tower locations");
	mvwaddstr(BODY,x++,0,"discharge batt  - Discharges the battery, draining it");
	mvwaddstr(BODY,x++,0,"                  fully. Helps prevent memory effect"); 
	mvwaddstr(BODY,x++,0,""); 
	do_hint("Press ENTER to return to MENU",NULL); 
	
	wrefresh(BODY);
	
	while(!done)
	{
		result=wgetch(BODY);
		if (result == 13 || result == 'q' || result == 'x')
		{  
			do_hint(NULL,NULL);
			werase(BODY);
			wrefresh(BODY);
			return;
		}
	}
}

void do_about()
{
	werase(BODY);
	mvwaddstr(BODY,1,0,"                     A B O U T");
	mvwaddstr(BODY,3,0," This program is device-driver and menu interface for");
	mvwaddstr(BODY,4,0," CTEK device, which was created for experiments with");
	mvwaddstr(BODY,5,0," AMPS Cellular Networks using OKI 900 phone.");
	mvwaddstr(BODY,6,0," This program is in BETA state, use it at own risk");
	mvwaddstr(BODY,7,0," some functions not implemented yet, also contains");
	mvwaddstr(BODY,8,0," number of bugs I belive.");
	mvwaddstr(BODY,10,0," Authors:	  Avoozl,  [dOPEmAN],  PoTom");
	mvwaddstr(BODY,12,0," Comments and sugestions are welcome, mail them to:");
	mvwaddstr(BODY,13,0,"		potom@techfreakz.org");
	mvwchgat(BODY,13,0,-1,A_BOLD,0,NULL);
	mvwaddstr(BODY,14,0," New versions, other ports,  will be available at:");
	mvwaddstr(BODY,15,0,"	  http://www.techfreakz.org/~potom");
	mvwchgat(BODY,15,0,-1,A_BOLD,0,NULL);
	mvwaddstr(BODY,16,0," Thanks to Banpaia Team and everyone in #cellular");
	mvwaddstr(BODY,17,0," 	Oh, yeah .......   Free Kevin !!!");
	wrefresh(BODY);
}


void not_yet(){
	nodelay(BODY,FALSE);
	werase(BODY);
	waddstr(BODY,"Not implemented in this Beta version.");
	do_hint("Press [ENTER] to return to menu", NULL);
	wgetch(BODY);
	werase(BODY);
	wrefresh(BODY);
}
