#include <string.h>
#include <stdio.h>
#include <unistd.h>

//  AT&T getopt()  , used here "u_getopt()" for portability
#ifndef EOF
#define EOF     (-1)
#endif
int opterr = 1;
int optind = 1;
int optopt = 0;
char *optarg = 0;
extern int u_getopt(int argc, char * const argv[], const char *opts);

int u_getopt(int argc, char * const argv[], const char *opts)
{
        static int sp = 1;
        register int c;
        register char *cp;

        if (sp == 1) {
                if (optind >= argc || (argv[optind][0] != '+' &&
                        argv[optind][0] != '-') || argv[optind][1] ==
'\0')
                        return EOF;
                else if (strcmp(argv[optind], "--") == 0) {
                        optind++;
                        return EOF;
                }
        /* '+' for config options, '+' should not be in the opts list */
                if (argv[optind][0] == '+') {

                        optarg = argv[optind++] + 1;
                        return '+';
                }
        }
        optopt = c = argv[optind][sp];
        if (c == ':' || (cp = strchr(opts, c)) == NULL) {
                (opterr ? fprintf(stderr,"\n%s: illegal option: -%c\n
",argv[0], c) :0);
                if (argv[optind][++sp] == '\0') {
                        optind++;
                        sp = 1;
                }
                return '\0';
        }
        if (*++cp == ':') {
                if (argv[optind][sp + 1] != '\0')
                        optarg = &argv[optind++][sp + 1];
                else if (++optind >= argc) {
                        (opterr ? fprintf(stderr,"%s: argument required
after: -%c\n",argv[0], c) :0);
                        sp = 1;
                        return '\0';

                } else
                        optarg = argv[optind++];
                sp = 1;
        } else {
                if (argv[optind][++sp] == '\0') {
                        sp = 1;
                        optind++;
                }
                optarg = NULL;
        }
        return c;
}


