#include <string.h>
#include <signal.h>
#include <setjmp.h>
#include <curses.h>
#include "cteklib.h"
#include "u_global.h"

void back_fcc(){
        //get_fcc(OKI_FCC_ABORT,NULL);
        //signal(SIGALRM,SIG_IGN);
        //      siglongjmp(alrmbrk,1);
        scanfcc(p_chan);
}
void scanfcc(int chan)
{

        bool status;
        char temp[100];
        int done,strongfcc,result,squelch=23;
        byte fvcstream[10000],fccstream[10000];
        void (*oldintr)(int);
	FMENU=newwin(20-2,17-2,1+1,0+1);
	touchwin(FMENU);
	wrefresh(FMENU);

	//if (scanfvc)
        //goto fvc_again;
        if (chan == 0)
                carrier=0;

        if (carrier == 0){
                werase(BODY);
                mvwaddstr(BODY,0,0,"Select Carrier (A/B) or press Q to return to MENU");
                wrefresh(BODY);
                done=0;
                while(!done)
                {
                        result=wgetch(BODY);

                        if (toupper(result) == (int)'Q')
                        {
                                do_hint(NULL,NULL);
                                werase(BODY);
                                wrefresh(BODY);

                                return;
                        }
                        if (toupper(result) == (int)'A')
                        {
                                carrier=1;
                                done=1;
                        }
                        if (toupper(result) == (int)'B')
                        {
                                carrier=2;
                                done=1;
                        }
                }
                do_hint(NULL,"[CTRL-C] - return to Menu");
                werase(BODY);
                waddstr(BODY,"Searching for strongest FCC channel..\n");
                wrefresh(BODY);
                strongfcc=find_fcc(carrier);

                sprintf(temp,"Chan: %d",strongfcc);
                p_chan= strongfcc;                // save current chan for return
                mvwaddstr(HINTBAR,0,3,temp);
                wrefresh(HINTBAR);
                sprintf(temp,"Scanning %d\n",strongfcc);
                waddstr(BODY,temp);
                wrefresh(BODY);
                set_channel(strongfcc);
                done=0;
        }
        else
                set_channel(p_chan);

        if(sigsetjmp(breakloop,1)) {
                (void) signal(SIGINT,exitprog);
                done=1;
        }
        signal(SIGINT,loopexit);
        //      if(sigsetjmp(alrmbrk,1)){
        //(void) signal(SIGALRM,SIG_DFL);
                //}
    while(!done) {
                //signal(SIGALRM,back_fcc);
                //alarm(3);
                status=get_fcc(OKI_FCC_GET,fccstream);
                //alarm(0);
                get_fcc(OKI_FCC_ABORT,NULL);
                //nodelay(BODY,TRUE);
                //result = wgetch(BODY);
                //if (result == (int)'q')
                //{
                //nodelay(BODY,FALSE);
                //loopexit(NULL);
                         //}
                //nodelay(BODY,FALSE);

                if(status) {
                        decode_fcc(fccstream,&oki_fcc);
                        if(oki_fcc.scc==3)
                        {
                                decode_order(oki_fcc.order,oki_fcc.ordq,type);
                                sprintf(temp,"FCC: scc %d dcc %d local %d (%s)%s-%s %s\n",oki_fcc.scc,oki_fcc.dcc,oki_fcc.local,oki_fcc.areacode,oki_fcc.prefix,oki_fcc.number,type);

                                waddstr(BODY,temp);
                                wrefresh(BODY);
                        }
                        else {
                                sprintf(temp,"FCC: scc %d dcc %d vmac %d chan %d (%s)%s-%s\n",oki_fcc.scc,oki_fcc.dcc,oki_fcc.vmac,oki_fcc.chan,oki_fcc.areacode,oki_fcc.prefix,oki_fcc.number);
                                waddstr(BODY,temp);
                                wrefresh(BODY);
                                if(oki_fcc.chan!=0) {
                                        set_channel(oki_fcc.chan);
                                        rx_audio_path(OKI_AUDIO_SOUNDER);
                                        rx_audio(TRUE);
                                        set_volume(6);
                                        done=1;
                                        scanfvc=1;
                                }
                        }
                }
        }
        if(sigsetjmp(breakloop,1)) {
                (void) signal(SIGINT,exitprog);
                scanfvc=0;
        }
        signal(SIGINT,loopexit);
        while(scanfvc) {
                sprintf(temp,"Chan: %d  Squelch: %d     RSS: %d", oki_fcc.chan , squelch, get_rss());
                mvwaddstr(HINTBAR,0,3,temp);
                wrefresh(HINTBAR);

                fvc_again:
                if (get_rss() < squelch )
                {
                        rx_audio(FALSE);
                        waddstr(BODY,"Released on squelch\n");
                        wrefresh(BODY);
                        sprintf(temp,"Chan: %d                  ",p_chan);
                        do_hint(temp,"[CTRL-C] - return to Menu");
                        scanfvc=0;
                        back_fcc();
                }
                //      signal(SIGALRM,back_fvc);
                //alarm(5);
                status=get_fvc(OKI_FVC_GET,fvcstream);
                //alarm(0);
                get_fvc(OKI_FCC_ABORT,NULL);
                if(status) {
                        decode_fvc(fvcstream,&oki_fvc);
                        if(oki_fvc.scc==3)
                        {
                                decode_order(oki_fvc.order,oki_fvc.ordq,type);
                                sprintf(temp,"FVC: scc %d pscc %d local %d %s\n",oki_fvc.scc,oki_fvc.pscc,oki_fvc.local,type);
                                waddstr(BODY,temp);

                                wrefresh(BODY);
                                if (oki_fvc.order == 3 || oki_fvc.order == 7 ||
get_rss() < squelch )
                                {
                                        rx_audio(FALSE);
                                        waddstr(BODY,"Released on audit\n");
                                        wrefresh(BODY);
                                        sprintf(temp,"Chan: %d
",p_chan);
                                        do_hint(temp,"[CTRL-C] - return to Menu");
                                        scanfvc=0;
                                        back_fcc();
                                }
                        }
                        else {
                                sprintf(temp,"FVC: scc %d pscc %d vmac %d chan %d\n",oki_fvc.scc,oki_fvc.pscc,oki_fvc.vmac,oki_fvc.chan);
                                set_channel(oki_fvc.chan);
                                waddstr(BODY,temp);

                                sprintf(temp,"Chan: %d  Squelch: %d     RSS: %d", oki_fvc.chan,squelch,get_rss());
                                do_hint(temp,"[CTRL-C] - return to Menu");
                                mvwaddstr(HINTBAR,0,3,temp);
                                wrefresh(BODY);

                        }
                }
        }

        get_fcc(OKI_FCC_ABORT,NULL);
        get_fvc(OKI_FCC_ABORT,NULL);
        rx_audio(FALSE);
        werase(BODY);
        wrefresh(BODY);

        waddstr(BODY,"Please Wait.. Clearing Buffers..\n");
        wrefresh(BODY);
        clearbuffer();
        werase(BODY);
        wrefresh(BODY);
	delwin(FMENU);
	touchwin(MENU);
	wrefresh(MENU);
}

void view_fcc()
{
        bool status;
        char temp[100];
        int done,strongfcc,result;
        byte fccstream[10000];
        void (*oldintr)(int);
	
	FMENU=newwin(20-2,17-2,1+1,0+1);
	touchwin(FMENU);
	wrefresh(FMENU);

        werase(BODY);
        mvwaddstr(BODY,0,0,"Select Carrier (A/B) or press Q to return to MENU");
        wrefresh(BODY);
        done=0;
        while(!done)
        {
                result=wgetch(BODY);
                if (toupper(result) == (int)'Q')
                {
                        do_hint(NULL,NULL);
                        werase(BODY);
                        wrefresh(BODY);
                        return;
                }
                if (toupper(result) == (int)'A')
                {
                        carrier=1;
                        done=1;
                }
                if (toupper(result) == (int)'B')
                {
                        carrier=2;
                        done=1;
                }
        }
        do_hint(NULL,"[CTRL-C] - Return to menu");
        werase(BODY);
        waddstr(BODY,"Searching for strongest FCC channel..\n");
        wrefresh(BODY);
        strongfcc=find_fcc(carrier);
        sprintf(temp,"Chan: %d\n",strongfcc);
        mvwaddstr(HINTBAR,0,3,temp);
        wrefresh(HINTBAR);
        sprintf(temp,"Scanning %d\n",strongfcc);
        waddstr(BODY,temp);

       wrefresh(BODY);
        set_channel(strongfcc);
        done=0;
        if(sigsetjmp(breakloop,1)) {
                (void) signal(SIGINT,exitprog);
                done=1;
        }
        signal(SIGINT,loopexit);
        while(!done) {
                status=get_fcc(OKI_FCC_GET,fccstream);
                get_fcc(OKI_FCC_ABORT,NULL);
                if(status) {
                        decode_fcc(fccstream,&oki_fcc);
                        if(oki_fcc.scc==3)
                        {
                                decode_order(oki_fcc.order,oki_fcc.ordq,type);
                                sprintf(temp,"SCC: %d (%s)%s-%s %s\n",oki_fcc.scc,oki_fcc.areacode,oki_fcc.prefix,oki_fcc.number,type);
                                waddstr(BODY,temp);
                                wrefresh(BODY);

                        }
                        else {
                                sprintf(temp,"SCC: %d (%s)%s-%s setup dcc: %d vmac: %d channel: %d\n",oki_fcc.scc,oki_fcc.areacode,oki_fcc.prefix,oki_fcc.number,oki_fcc.dcc,oki_fcc.vmac,oki_fcc.chan);
                                waddstr(BODY,temp);
                                wrefresh(BODY);
                        }
                }
        }
        if(sigsetjmp(breakloop,1)) {
                (void) signal(SIGINT,exitprog);
        }
        get_fcc(OKI_FCC_ABORT,NULL);
        werase(BODY);
        wrefresh(BODY);
        waddstr(BODY,"Please Wait.. Clearing Buffers..\n");
        wrefresh(BODY);
        clearbuffer();
        werase(BODY);
        wrefresh(BODY);
	delwin(FMENU);
	touchwin(MENU);
	wrefresh(MENU);

}
void find_towers()
{
        int result,done=0,strongfcc,stregnth,x=0,q=0,bar,peak=0,peaktmp;
        int mode=0;
// mode 0 - tower locate  mode 1 - cell limit locate
        char temp[100],barchar;
        float freq;
        FILE *towerlog;

        werase(BODY);
        mvwaddstr(BODY,0,0,"Select Carrier (A/B) or press Q to return to MENU");
        wrefresh(BODY);
        barchar=ACS_BULLET;
        if (!IS_COLORS)
                barchar='.';
        while(!done)
        {
                result=wgetch(BODY);
                if (toupper(result) == (int)'Q')
                {
                        do_hint(NULL,NULL);

                        werase(BODY);
                        wrefresh(BODY);
                        return;
                }
                if (toupper(result) == (int)'A')
                {
                        carrier=1;
                        done=1;
                }
                if (toupper(result) == (int)'B')
                {
                        carrier=2;
                        done=1;
                }
        }
        werase(BODY);
        mvwaddstr(BODY,0,0,"Scanning.. Please Wait..
      ");
        wrefresh(BODY);

        done=0;

        scan_strong_fcc:

                strongfcc=find_fcc(carrier);
        set_channel(strongfcc);
        freq=channel_to_ffreq(strongfcc);

        change_modes:
                mvwaddstr(BODY,0,0,"
");
        wrefresh(BODY);
        do_hint("       Q - Menu  R - Rescan  C - Carrier  L - Log  M - Mode",NULL);
        if (mode == 0)
                mvwaddstr(BODY,2,0,"Mode: Tower Locate");
        if (mode == 1)
                mvwaddstr(BODY,2,0,"Mode: Cell Limit Locate");
        if (carrier == 1)
                sprintf(temp,"Closest A Carrier Tower FCC: %d (%3.3f Mhz)",strongfcc,freq);
        if (carrier == 2)
                sprintf(temp,"Closest B Carrier Tower FCC: %d (%3.3f Mhz)",strongfcc,freq);
        mvwaddstr(BODY,4,0,temp);
        wrefresh(BODY);
        nodelay(BODY,TRUE);

        while (!done)
        {
                result=wgetch(BODY);
                if (toupper(result) == (int)'Q')
                {
                        do_hint(NULL,NULL);
                        werase(BODY);
                        wrefresh(BODY);
                        nodelay(BODY,FALSE);
                        done=1;
                        return;
                }
                if (toupper(result) == (int)'C')
                {
                        if (carrier==1)
                                carrier=2;
                        else if (carrier==2)

                                carrier=1;
                        peak=0;
                        mvwaddstr(BODY,4,0,"Scanning.. Please Wait..
                      ");
                        mvwaddstr(BODY,8,0,"Signal
                     ");
                        mvwaddstr(BODY,9,0,"Peak
                     ");
                        mvwaddstr(BODY,5,0,"Signal Stregnth: 0   ");
                        mvwaddstr(BODY,6,0,"  Peak Stregnth: 0   ");
                        wrefresh(BODY);
                        goto scan_strong_fcc;
                }
                if (toupper(result) == (int)'R')
                {
                        peak=0;
                        mvwaddstr(BODY,4,0,"Scanning.. Please Wait..
                      ");
                        mvwaddstr(BODY,8,0,"Signal
                     ");
                        mvwaddstr(BODY,9,0,"Peak
                     ");

                        mvwaddstr(BODY,5,0,"Signal Stregnth: 0   ");
                        mvwaddstr(BODY,6,0,"  Peak Stregnth: 0   ");
                        wrefresh(BODY);
                        goto scan_strong_fcc;
                }
                if (toupper(result) == (int)'L')
                {
                        nodelay(BODY,FALSE);
                        towerlog=fopen("tower_log","a");
                        if (towerlog == NULL){
                                mvwaddstr(BODY,13,0,"Error: Cant open tower_log");
                                wrefresh(BODY); sleep(2);
                        }
                        else {
                                mvwaddstr(BODY,13,0,"Enter Tower Location: ");
                                mvwaddstr(BODY,14,0,"
                               ");
                                if(IS_COLORS)
                                        mvwchgat(BODY,14,0,58,A_BOLD,WHITE_BLUE,NULL);
                                else

                                        mvwchgat(BODY,14,0,58,A_REVERSE,0,NULL);                                wrefresh(BODY);
                                done=0;
                                x=0;
                                keypad(BODY,TRUE);
                                temp[0]=(char)NULL;
                                while (!done)
                                {
                                        result=wgetch(BODY);
                                        if (result == 13)
                                                done=1;
                                        else if (x<58)
                                        {
                                                if (result>=32 && result<=126)
                                                {
                                                        mvwaddch(BODY,14,x,result);
                                                        if (IS_COLORS)
                                                                mvwchgat(BODY,14,x,1,A_BOLD,WHITE_BLUE,NULL);
                                                        else

                                                                mvwchgat(BODY,14,x,1,A_REVERSE,0,NULL);

                                                        wrefresh(BODY);
                                                        temp[x++]=(char)result;
                                                }
                                                else if (result == KEY_BACKSPACE)
                                                {
                                                        if (x-1<0)
                                                                x=1;
                                                        mvwaddch(BODY,14,--x,' ');
                                                        if (IS_COLORS

                                                                )
                                                                mvwchgat(BODY,14,x,1,A_BOLD,WHITE_BLUE,NULL);
                                                        else
                                                                mvwchgat(BODY,14,x,1,A_REVERSE,0,NULL);

                                                        wrefresh(BODY);
                                                        temp[x]=(char)' ';
                                                }
                                        }
                                }
                                done=0;
                                temp[x]=(char)NULL;
                                if (carrier==1)
                                        fprintf(towerlog,"A %d LOCATION: %s\n",strongfcc,temp);
                                else if (carrier==2)
                                        fprintf(towerlog,"B %d LOCATION: %s\n",strongfcc,temp);
                                fclose(towerlog);
                        }
                        nodelay(BODY,TRUE);
                        mvwaddstr(BODY,13,0,"
             ");
                        mvwaddstr(BODY,14,0,"
                        ");

                        wrefresh(BODY);
                }
                else
                {
                        stregnth=get_rss();
                        bar=stregnth/2;
                        if (stregnth > peak)
                                peak = stregnth;
                        sprintf(temp,"Signal Stregnth: %d   ",stregnth);
                        mvwaddstr(BODY,5,0,temp);
                        sprintf(temp,"  Peak Stregnth: %d   ",peak);
                        mvwaddstr(BODY,6,0,temp);
                        mvwaddstr(BODY,8,0,"Signal ");
                        mvwaddstr(BODY,9,0,"Peak   ");
                        mvwaddstr(BODY,10,0,"       |+++++++++|+++++++++|+++++++++|+++++++++|+++++++++|");
                        mvwaddstr(BODY,11,0,"       0         20        40        60        80       100");
                        for (x=0;x<bar;x++)
                        {
                                mvwaddch(BODY,8,x+7,barchar);
                                if (IS_COLORS)
                                        mvwchgat(BODY,8,x+7,1,A_BOLD,GREEN_BLACK,NULL);
                                else
                                        mvwchgat(BODY,8,x+7,1,A_REVERSE,0,NULL);
                        }
                        if (peak == stregnth)
                        {
                                peaktmp=peak/2;
                                for (x=0;x<peaktmp;x++)
                                {
                                        mvwaddch(BODY,9,x+7,barchar);
                                        if (IS_COLORS)
                                                mvwchgat(BODY,9,x+7,1,A_NORMAL,RED_BLACK,NULL);

                                        else
                                                mvwchgat(BODY,9,x+7,1,A_REVERSE,0,NULL);
                                }
                        }
                        wrefresh(BODY);
                }
        }

}

