// ttyio.c - handles COM port.  Avoozl, [dOPEMan], PoTom  		1998-99

#include <stdio.h>
#include <termios.h>
#include <fcntl.h>
#include <signal.h>
#include <setjmp.h>
#include "cteklib.h"

int hCommPort;
static sigjmp_buf alrmcatch;
struct termios options;

bool open_comport(const char *port)
{
	int flags;
	hCommPort = open(port,O_RDWR | O_NOCTTY | O_NDELAY);
	if(hCommPort == -1)
	{
	  	//  printf("port = %s\n",port);
		return FALSE;
	}
	flags = fcntl(hCommPort,F_SETFL,0);         //wait for read() to exit
	fcntl(hCommPort,F_GETFL,flags & ~O_NDELAY); 
	tcgetattr(hCommPort, &options);             //get current settings
	cfsetispeed(&options, B2400);               //set in speed to 2400
	cfsetospeed(&options, B2400);               //set out speed to 2400
	options.c_cflag |= (CLOCAL | CREAD);        
	tcsetattr(hCommPort, TCSANOW, &options);    //set new options
	options.c_cflag &= ~PARENB;                 //set port to 8N1
	options.c_cflag &= ~CSTOPB;
	options.c_cflag &= ~CSIZE;
	options.c_cflag |= CS8;
	options.c_cflag &= ~CRTSCTS;                //disable hdwr flow control
	options.c_lflag &= ~(ICANON | ECHO | ISIG); //raw input is unprocessed
	
//	options.c_cc[VTIME] = 40;   		    // these 2 look best to use 
//	options.c_cc[VMIN]  = 0;    		    // let see when we need them
	
	tcsetattr(hCommPort, TCSANOW, &options);    //set new options
	
	
	return TRUE;
}


void close_comport()
{
	close(hCommPort);
}



void ct_write(const void *buf, size_t count)
{
	int x;
	
	for(x=0;x<count;x++) 
		write(hCommPort,&((char *)buf)[x], 1);
}


void ct_read( void *buf, size_t count)
{
	int x;
	
	for(x=0;x<count;x++)
	{
		read(hCommPort, &((char *)buf)[x], 1);
	}
}

void clearbuffer()
{
	int x,cnt;
	byte value;
	void (*oldintr)(int);
	
	x=0;
	if(sigsetjmp(alrmcatch,1)) { 
		if(oldintr) 
			(void) signal(SIGALRM,oldintr);
		x++;
		alarm(0);
	}
	oldintr=signal(SIGALRM,alarmbreak);
	while(x<5) {
		alarm(1);
		cnt=read(hCommPort,&value,1);
		alarm(0);
		if(cnt<1) 
			x++;
	}
}


void alarmbreak(int sig)
{
	siglongjmp(alrmcatch,1);
}


void alarmabort(int sig)
{
	siglongjmp(alrmcatch,1);
}

