// cteklib.c  -main routines + utilities   Avoozl, [dOPEMan], PoTom     1998-99

#include <string.h>
#include <fcntl.h>
#include <termios.h>
#include <unistd.h>
#include <ctype.h>
#include "cteklib.h"
extern int streamlen;
byte checksumstream[10000];
byte oldchecksum;
extern char romversion[4];

/////////////////////////////////////////////////////////////////////////////
// Oki900
/////////////////////////////////////////////////////////////////////////////
// Oki900 message handlers
//Returns the hex value of the data entered.
int checkinput(int inputval)
{
	if((inputval>=48) && (inputval<=57))
		return (inputval-48);            
	else if ((inputval>=65) && (inputval<=70))
		return (inputval-55);
	else
		return 15;
}

void sendkey(byte MODE)
{
	byte KEY_RELEASE[2] = {0xC4,0xB0};
	byte KEY_1[2] = {0xC4,0xB1};
	byte KEY_2[2] = {0xC4,0xB2};
	byte KEY_3[2] = {0xC4,0xB3};
	byte KEY_4[2] = {0xC4,0xB4};
	byte KEY_5[2] = {0xC4,0xB5};
	byte KEY_6[2] = {0xC4,0xB6};
	byte KEY_7[2] = {0xC4,0xB7};
	byte KEY_8[2] = {0xC4,0xB8};
	byte KEY_9[2] = {0xC4,0xB9};
	byte KEY_0[2] = {0xC4,0xBA};
	byte KEY_STAR[2] = {0xC4,0xBB};
	byte KEY_POUND[2] = {0xC4,0xBC};
	byte KEY_SND[2] = {0xC4,0xBD};
	byte KEY_END[2] = {0xC4,0xBE};
	byte KEY_RCL[2] = {0xC5,0xB3};
	byte KEY_STO[2] = {0xC5,0xB2};
	byte KEY_ALPH[2] = {0xC5,0xBA};
	byte KEY_MENU[2] = {0xC5,0xB6};
	byte KEY_CLR[2] = {0xC5,0xB1};
	byte KEY_UP[2] = {0xC5,0xB5};
	byte KEY_DOWN[2] = {0xC5,0xB4};
	
	byte d;
	
	d=0xC0;
	ct_write(&d,1);    //used for compatibility 
                                                     //with win95
	switch(MODE) {
		case OKI_KEY_1: 
			ct_write(&KEY_1,sizeof(KEY_1));
			break;
		case OKI_KEY_2:
			ct_write(&KEY_2,sizeof(KEY_2));
			break;
		case OKI_KEY_3: 
			ct_write(&KEY_3,sizeof(KEY_3));
			break;
		case OKI_KEY_4: 
			ct_write(&KEY_4,sizeof(KEY_4));
			break;
		case OKI_KEY_5: 
			ct_write(&KEY_5,sizeof(KEY_5));
			break;
		case OKI_KEY_6: 
			ct_write(&KEY_6,sizeof(KEY_6));
			break;
		case OKI_KEY_7:	
			ct_write(&KEY_7,sizeof(KEY_7));
			break;
		case OKI_KEY_8:	
			ct_write(&KEY_8,sizeof(KEY_8));
			break;
		case OKI_KEY_9: 
			ct_write(&KEY_9,sizeof(KEY_9));
			break;
		case OKI_KEY_0: 
			ct_write(&KEY_0,sizeof(KEY_0));
			break;
		case OKI_KEY_SND: 
			ct_write(&KEY_SND,sizeof(KEY_SND));
			break;
		case OKI_KEY_END: 
			ct_write(&KEY_END,sizeof(KEY_END));
			break;
		case OKI_KEY_STAR: 
			ct_write(&KEY_STAR,sizeof(KEY_STAR));
			break;
		case OKI_KEY_POUND: 
			ct_write(&KEY_POUND,sizeof(KEY_POUND));
			break;
		case OKI_KEY_RCL: 
			ct_write(&KEY_RCL,sizeof(KEY_RCL));
			break;
		case OKI_KEY_STO: 
			ct_write(&KEY_STO,sizeof(KEY_STO));
			break;
		case OKI_KEY_ALPH: 
			ct_write(&KEY_ALPH,sizeof(KEY_ALPH));
			break;
		case OKI_KEY_MENU: 
			ct_write(&KEY_MENU,sizeof(KEY_MENU));
			break;
		case OKI_KEY_CLR: 
			ct_write(&KEY_CLR,sizeof(KEY_CLR));
			break;
		case OKI_KEY_UP: 
			ct_write(&KEY_UP,sizeof(KEY_UP));
			break;
		case OKI_KEY_DOWN: 
			ct_write(&KEY_DOWN,sizeof(KEY_DOWN));
			break;
		case OKI_KEY_RELEASE: 
			ct_write(&KEY_RELEASE,sizeof(KEY_RELEASE));
			break;
	}
	
}

bool initialize_oki(byte MODE)
{
	byte INIT_OKI[6] = {0xC0,0xC0,0xA3,0xC0,0xC0,0xA1};
	byte MODE_NORMAL[6] = {0xC1,0xC0,0xB4,0xC0,0xD5,0xB3};
	byte MODE_TEST1[3] = {0xC1,0xC0,0xB4};
	byte MODE_TEST2[3] = {0xC0,0xDF,0xB1};
	byte MODE_TEST3[3] = {0xC1,0xF1,0xB7};
	byte MODE_TEST4[3] = {0xC1,0xF1,0xB9};
	byte MODE_TEST5[3] = {0xC1,0xF0,0xB0};
	byte MODE_TEST6[3] = {0xC1,0xF2,0xB7};
	byte okiresponse[3];
	
	ct_write(&INIT_OKI,sizeof(INIT_OKI));
	ct_read(&okiresponse,sizeof(okiresponse));
	ct_read(&okiresponse,sizeof(okiresponse));
	switch(MODE) {
		case OKI_MODE_NORMAL:
			ct_write(&MODE_NORMAL,sizeof(MODE_NORMAL));
			break;
		case OKI_MODE_TEST:
			ct_write(&MODE_TEST1,sizeof(MODE_TEST1));
			ct_write(&MODE_TEST2, sizeof(MODE_TEST2));
			ct_read(&okiresponse,sizeof(okiresponse));
			ct_write(&MODE_TEST3, sizeof(MODE_TEST3));
			ct_read(&okiresponse,sizeof(okiresponse));
			//Rom version is returned on initialization
			romversion[0]=(char)(okiresponse[2]-0xC0);
			romversion[1]=(char)(okiresponse[3]-0xB0);
			ct_read(&okiresponse,sizeof(okiresponse));
			romversion[2]=(char)(okiresponse[2]-0xC0);
			romversion[3]=(char)(okiresponse[3]-0xB0);		
			ct_write(&MODE_TEST4, sizeof(MODE_TEST4));
			ct_write(&MODE_TEST5, sizeof(MODE_TEST5));
			ct_write(&MODE_TEST6, sizeof(MODE_TEST6));
			ct_read(&okiresponse,sizeof(okiresponse));	
			break;
	}
	return TRUE;
}

void turn_off_oki()
{
	byte TURN_OFF[6] = {0xC0,0xC0,0xA2,0xC0,0xC0,0xA0};
	
	ct_write(&TURN_OFF,sizeof(TURN_OFF));
}

void rx_audio(bool state)
{
	byte UNMUTE_RX_AUDIO[3] = {0xC1,0xF0,0xBC};
	byte MUTE_RX_AUDIO[3] = {0xC1, 0xF0, 0xBB};
	
	if(state==TRUE)
		ct_write(&UNMUTE_RX_AUDIO,sizeof(UNMUTE_RX_AUDIO));
	else
		ct_write(&MUTE_RX_AUDIO,sizeof(MUTE_RX_AUDIO));
}

void rx_audio_path(byte MODE)
{
	byte AUDIO_PATH_EARPIECE[3] = {0xC1,0xF4,0xBC};
	byte AUDIO_PATH_SOUNDER[3] = {0xC1,0xF4,0xBD};
	byte AUDIO_PATH_EXTERNAL[3] = {0xC1,0xF4,0xBB};
	
	switch(MODE) {
		case OKI_AUDIO_EARPIECE: 
			ct_write(&AUDIO_PATH_EARPIECE,sizeof(AUDIO_PATH_EARPIECE));
			break;
		case OKI_AUDIO_SOUNDER:  
			ct_write(&AUDIO_PATH_SOUNDER,sizeof(AUDIO_PATH_SOUNDER));
			break;
		case OKI_AUDIO_EXTERNAL: 
			ct_write(&AUDIO_PATH_EXTERNAL,sizeof(AUDIO_PATH_EXTERNAL));
			break;
	}
}

void tx_audio(bool state)
{
	byte UNMUTE_TX_AUDIO[3] = {0xC1,0xF0,0xBE};
	byte MUTE_TX_AUDIO[3] = {0xC1,0xF0,0xBD};
	
	if(state==TRUE)
		ct_write(&UNMUTE_TX_AUDIO,sizeof(UNMUTE_TX_AUDIO));
	else
		ct_write(&MUTE_TX_AUDIO,sizeof(MUTE_TX_AUDIO));
}

void set_comp_exp(bool state)
{
	byte COMPRESSOR_ON[3] = {0xC1,0xF4,0xB1};
	byte COMPRESSOR_OFF[3] = {0xC1,0xF4,0xB2};
	
	if(state == TRUE)
		ct_write(&COMPRESSOR_ON,sizeof(COMPRESSOR_ON));
	else
		ct_write(&COMPRESSOR_OFF,sizeof(COMPRESSOR_OFF));
}

void set_volume(int level)
{
	byte VOLUME_LEVEL[5] = {0xC1,0xF4,0xB3,0xC1,0xF0};
	
	byte d;
	
	ct_write(&VOLUME_LEVEL,sizeof(VOLUME_LEVEL));
	d=(byte) level+0xB0;
	ct_write(&d,sizeof(d));
}

void audio_tone(byte tone, bool state)
{
	byte TONE_LOW_ON[3] = {0xC1,0xF2,0xB5};
	byte TONE_LOW_OFF[3] = {0xC1,0xF2,0xB6};
	byte TONE_HIGH_ON[3] = {0xC1,0xF2,0xB3};
	byte TONE_HIGH_OFF[3] = {0xC1,0xF2,0xB4};
	
	if(tone == OKI_TONE_LOW)
		if(state == TRUE)
			ct_write(&TONE_LOW_ON,sizeof(TONE_LOW_ON));
		else
			ct_write(&TONE_LOW_OFF,sizeof(TONE_LOW_OFF));
	else
		if(state == TRUE)
			ct_write(&TONE_HIGH_ON,sizeof(TONE_HIGH_ON));
		else
			ct_write(&TONE_HIGH_OFF,sizeof(TONE_HIGH_OFF));
}

void set_carrier(bool state)
{
	byte CARRIER_ON[3] = {0xC1,0xF0,0xB7};
	byte CARRIER_OFF[3] = {0xC1,0xF0,0xB8};
	
	if(state == TRUE)
		ct_write(&CARRIER_ON,sizeof(CARRIER_ON));
	else
		ct_write(&CARRIER_OFF,sizeof(CARRIER_OFF));
}

void tx_power(int level)
{
	byte TX_POWER_LEVEL[5] = {0xC1,0xF0,0xBA,0xC1,0xF0};
	byte d;
	
	ct_write(&TX_POWER_LEVEL,sizeof(TX_POWER_LEVEL));
	d=(byte) level+0xB0;
	ct_write(&d,sizeof(d));
}

void set_sat(int sat)
{
	byte SAT_TONE[5] = {0xC1,0xF2,0xB0,0xC1,0xF0};
	
	byte d;
	
	ct_write(&SAT_TONE,sizeof(SAT_TONE));
	d=(byte) sat+0xB0;
	ct_write(&d,sizeof(d));
}

int get_battery_level(voltage)
float *voltage;
{
	byte GET_BATTERY_LEVEL[6]={0xC1,0xF5,0xB1,0xC1,0xF0,0xB2};
	byte battery_level[3];
	byte level,v;
	
	ct_write(&GET_BATTERY_LEVEL,sizeof(GET_BATTERY_LEVEL));
	ct_read(&battery_level,sizeof(battery_level));
	level=(battery_level[1]-0xc0)*16+(battery_level[2]-0xb0);
	*voltage=(float)((level*0.045)-0.470) ;
	if(level >= 0x99) 		v=8;
	else if(level >= 0x97)		v=7;
	else if(level >= 0x94)		v=6;
	else if(level >= 0x91)	v=5;
	else if(level >= 0x8f)	v=4;
	else if(level >= 0x8c)	v=3;
	else if(level >= 0x8a)	v=2;
	else if(level >= 0x87)	v=1;
	else if(level < 0x87)	v=0;
	
	return (v);
}

void ct_battery_discharge(bool swtch)
{
	byte DISPLAY[6]={0xc1,0xf4,0xba,0xc1,0xf0,0xb0};
        byte LEDSON[6]={0xc1,0xfb,0xb0,0xc1,0xf0,0xb8};
        byte LEDSOFF[6]={0xc1,0xfb,0xb0,0xc1,0xf0,0xb0};
        byte DISPLAYOFF[6]={0xc1,0xff,0xbf,0xc1,0xff,0xbf};
        byte BATTMON[6]={0xc1,0xf0,0xb0,0xc1,0xf3,0xbc};
        byte CLEARD[6]={0xc1,0xf0,0xb0,0xc1,0xf0,0xb0};
	
	if(swtch)
		{
		 ct_write(&DISPLAY,sizeof(DISPLAY));
                 ct_write(&LEDSON,sizeof(LEDSON));
                 ct_write(&BATTMON,sizeof(BATTMON));
                 ct_write(&DISPLAYOFF,sizeof(DISPLAYOFF));
                 set_channel(0);
                 tx_power(0);
                 set_carrier(TRUE);
		}
	else
		{
		 ct_write(&DISPLAY,sizeof(DISPLAY));
        	 ct_write(&LEDSOFF,sizeof(LEDSOFF));
        	 ct_write(&CLEARD,sizeof(CLEARD));
          	 ct_write(&DISPLAYOFF,sizeof(DISPLAYOFF));
         	 set_carrier(FALSE);
		}

}



int get_rss()
{
	byte GET_RSS[3] = {0xC1,0xF3,0xB5};
	
	byte rss[3];
	
	ct_write(&GET_RSS,sizeof(GET_RSS));
	ct_read(&rss,sizeof(rss));
	return (16*(rss[1]-0xC4)+(rss[2]-0xB0));
}

bool get_custom_msg(char *msg)
{
	byte READ_MEM[3] = {0xC1,0xF1,0xB9};
	byte custmsg1[6] = {0xC1,0xFB,0xBE,0xC1,0xFA,0xBF};
	byte custmsg2[6] = {0xC1,0xFB,0xBE,0xC1,0xFB,0xB0};
	byte custmsg3[6] = {0xC1,0xFB,0xBE,0xC1,0xFB,0xB1};
	byte custmsg4[6] = {0xC1,0xFB,0xBE,0xC1,0xFB,0xB2};
	byte custmsg5[6] = {0xC1,0xFB,0xBE,0xC1,0xFB,0xB3};
	byte custmsg6[6] = {0xC1,0xFB,0xBE,0xC1,0xFB,0xB4};
	byte custmsg7[6] = {0xC1,0xFB,0xBE,0xC1,0xFB,0xB5};
	byte custmsg8[6] = {0xC1,0xFB,0xBE,0xC1,0xFB,0xB6};
	byte result[3];
	int x=0;
	
	ct_write(&READ_MEM,sizeof(READ_MEM));
	ct_write(&custmsg1,sizeof(custmsg1));
	ct_read(&result,sizeof(result));
	msg[x++]=(char)convert(result[1],result[2]);
	ct_write(&READ_MEM,sizeof(READ_MEM));
	ct_write(&custmsg2,sizeof(custmsg2));
	ct_read(&result,sizeof(result));
	msg[x++]=(char)convert(result[1],result[2]);
	ct_write(&READ_MEM,sizeof(READ_MEM));
	ct_write(&custmsg3,sizeof(custmsg3));
	ct_read(&result,sizeof(result));
	msg[x++]=(char)convert(result[1],result[2]);
	ct_write(&READ_MEM,sizeof(READ_MEM));
	ct_write(&custmsg4,sizeof(custmsg4));
	ct_read(&result,sizeof(result));
	msg[x++]=(char)convert(result[1],result[2]);
	ct_write(&READ_MEM,sizeof(READ_MEM));
	ct_write(&custmsg5,sizeof(custmsg5));
	ct_read(&result,sizeof(result));
	msg[x++]=(char)convert(result[1],result[2]);
	ct_write(&READ_MEM,sizeof(READ_MEM));
	ct_write(&custmsg6,sizeof(custmsg6));
	ct_read(&result,sizeof(result));
	msg[x++]=(char)convert(result[1],result[2]);
	ct_write(&READ_MEM,sizeof(READ_MEM));
	ct_write(&custmsg7,sizeof(custmsg7));
	ct_read(&result,sizeof(result));
	msg[x++]=(char)convert(result[1],result[2]);
	ct_write(&READ_MEM,sizeof(READ_MEM));
	ct_write(&custmsg8,sizeof(custmsg8));
	ct_read(&result,sizeof(result));
	msg[x++]=(char)convert(result[1],result[2]);
	msg[x]='\0';
	return TRUE;
}
void set_custom_msg(char *msg)
{
	byte msghex[2],value[3];
	byte custmsg1[6] = {0xC1,0xFB,0xBE,0xC1,0xFA,0xBF};
	byte custmsg2[6] = {0xC1,0xFB,0xBE,0xC1,0xFB,0xB0};
	byte custmsg3[6] = {0xC1,0xFB,0xBE,0xC1,0xFB,0xB1};
	byte custmsg4[6] = {0xC1,0xFB,0xBE,0xC1,0xFB,0xB2};
	byte custmsg5[6] = {0xC1,0xFB,0xBE,0xC1,0xFB,0xB3};
	byte custmsg6[6] = {0xC1,0xFB,0xBE,0xC1,0xFB,0xB4};
	byte custmsg7[6] = {0xC1,0xFB,0xBE,0xC1,0xFB,0xB5};
	byte custmsg8[6] = {0xC1,0xFB,0xBE,0xC1,0xFB,0xB6};
	
	convert_hex_twohex(msghex,(byte)msg[0]);
	value[0] = 0xC1;
	value[1] = msghex[0];
	value[2] = msghex[1];
	write_memory(custmsg1,value);
	
	convert_hex_twohex(msghex,(byte)msg[1]);
	value[0] = 0xC1;
	value[1] = msghex[0];
	value[2] = msghex[1];
	write_memory(custmsg2,value);
	
	convert_hex_twohex(msghex,(byte)msg[2]);
	value[0] = 0xC1;
	value[1] = msghex[0];
	value[2] = msghex[1];
	write_memory(custmsg3,value);
	
	convert_hex_twohex(msghex,(byte)msg[3]);
	value[0] = 0xC1;
	value[1] = msghex[0];
	value[2] = msghex[1];
	write_memory(custmsg4,value);
	
	convert_hex_twohex(msghex,(byte)msg[4]);
	value[0] = 0xC1;
	value[1] = msghex[0];
	value[2] = msghex[1];
	write_memory(custmsg5,value);
	
	convert_hex_twohex(msghex,(byte)msg[5]);
	value[0] = 0xC1;
	value[1] = msghex[0];
	value[2] = msghex[1];
	write_memory(custmsg6,value);
	
	convert_hex_twohex(msghex,(byte)msg[6]);
	value[0] = 0xC1;
	value[1] = msghex[0];
	value[2] = msghex[1];
	write_memory(custmsg7,value);
	
	convert_hex_twohex(msghex,(byte)msg[7]);
	value[0] = 0xC1;
	value[1] = msghex[0];
	value[2] = msghex[1];
	write_memory(custmsg8,value);
}

void write_memory(byte address[6],byte value[3])
{
	byte ADDRESS[6] = {address[0],address[1],address[2],address[3],address[4],address[5]};
	byte VALUE[3] = {value[0],value[1],value[2]};
	byte WRITE_MEM[3] = {0xC1,0xF3,0xB6};
	
	ct_write(&WRITE_MEM,sizeof(WRITE_MEM));
	ct_write(&ADDRESS,sizeof(ADDRESS));
	ct_write(&VALUE,sizeof(VALUE));
}

byte convert(byte first, byte second)
{
	return (16*(first-0xC0)+(second-0xB0));
}

void convert_hex_twohex(byte hexcode[2], byte hex)
{
	byte temp;
	temp=(byte)((int)hex/16);
	hexcode[1]=(byte)((byte)((int)hex-((int)temp*16))+0xB0);
	hexcode[0]=temp+0xF0;
}

void break_hex(byte hexcode[2],byte hex)
{
	byte temp;
	temp=(byte)((int)hex/16);
	hexcode[1]=(byte)((byte)((int)hex-((int)temp*16)));
	hexcode[0]=temp;
}
void convert_hex_bin(byte hexvalue, int *bin)
{
	int x,number,bit;
	unsigned int mask;
	
	mask=0x0008;
	number=(int)hexvalue;
	for(x=0;x<4;x++)
	{
		bit=(mask & number) ? 1 : 0;
		bin[x]=bit;
		mask >>=1;
	}
}

void read_nam(struct nam *nam_info,byte NAM)
{
	int temp[5],min1[24],min2[10];
	int y,w,a;
	char tempmin[16];
	byte READ_MEM[3] = {0xC1,0xF1,0xB9};
	byte result[3],stream[28],temphexcode[2],CURRENT_ADDRESS[6];
	byte temphex;
	
	switch(NAM) {
		case NAM1:
			CURRENT_ADDRESS[0]=0xC1;
			CURRENT_ADDRESS[1]=0xFA;
			CURRENT_ADDRESS[2]=0xB0;
			CURRENT_ADDRESS[3]=0xC1;
			CURRENT_ADDRESS[4]=0xF2;
			CURRENT_ADDRESS[5]=0xBB;
			break;
		case NAM2:
			CURRENT_ADDRESS[0]=0xC1;
			CURRENT_ADDRESS[1]=0xFA;
			CURRENT_ADDRESS[2]=0xB2;
			CURRENT_ADDRESS[3]=0xC1;
			CURRENT_ADDRESS[4]=0xFE;
			CURRENT_ADDRESS[5]=0xBB;
			break;
		case NAM3:
			CURRENT_ADDRESS[0]=0xC1;
			CURRENT_ADDRESS[1]=0xFA;
			CURRENT_ADDRESS[2]=0xB5;
			CURRENT_ADDRESS[3]=0xC1;
			CURRENT_ADDRESS[4]=0xFA;
			CURRENT_ADDRESS[5]=0xBB;
			break;
		case NAM4:
			CURRENT_ADDRESS[0]=0xC1;
			CURRENT_ADDRESS[1]=0xFA;
			CURRENT_ADDRESS[2]=0xB8;
			CURRENT_ADDRESS[3]=0xC1;
			CURRENT_ADDRESS[4]=0xF6;
			CURRENT_ADDRESS[5]=0xBB;
			break;
		case NAM5:
			CURRENT_ADDRESS[0]=0xC1;
			CURRENT_ADDRESS[1]=0xFA;
			CURRENT_ADDRESS[2]=0xBB;
			CURRENT_ADDRESS[3]=0xC1;
			CURRENT_ADDRESS[4]=0xF2;
			CURRENT_ADDRESS[5]=0xBB;
			break;
	}
	y=0;
	for(a=0;a<13;a++)
	{
		ct_write(&READ_MEM,sizeof(READ_MEM));
		ct_write(&CURRENT_ADDRESS,sizeof(CURRENT_ADDRESS));
		ct_read(&result,sizeof(result));
		temphex=convert(result[1],result[2]);
		break_hex(temphexcode,temphex);
		stream[y++]=temphexcode[0];
		stream[y++]=temphexcode[1];
		if(CURRENT_ADDRESS[4]>0xFB) {
			CURRENT_ADDRESS[2]=CURRENT_ADDRESS[2]+0x01;
			CURRENT_ADDRESS[4]=0xF0+(0x03-(0xFF-CURRENT_ADDRESS[4]));
		}
		else
			CURRENT_ADDRESS[4]=CURRENT_ADDRESS[4]+0x04;
	}
	CURRENT_ADDRESS[0]=0xC1;
	CURRENT_ADDRESS[1]=0xFB;
	CURRENT_ADDRESS[2]=0xB0;
	CURRENT_ADDRESS[3]=0xC1;
	CURRENT_ADDRESS[4]=0xF6;
	CURRENT_ADDRESS[5]=0xBB;
	ct_write(&READ_MEM,sizeof(READ_MEM));
	ct_write(&CURRENT_ADDRESS,sizeof(CURRENT_ADDRESS));
	ct_read(&result,sizeof(result));
	oldchecksum=convert(result[1],result[2]);
	y=0;
	w=4;
	nam_info->sid=(int)((int)stream[1]*256+(int)stream[2]*16+(int)stream[3]);
	convert_hex_bin(stream[w],temp);
	min2[y++]=temp[2];
	min2[y++]=temp[3];
	w++;
	convert_hex_bin(stream[w],temp);
	min2[y++]=temp[0];
	min2[y++]=temp[1];
	min2[y++]=temp[2];
	min2[y++]=temp[3];
	w++;
	convert_hex_bin(stream[w],temp);
	min2[y++]=temp[0];
	min2[y++]=temp[1];
	min2[y++]=temp[2];
	min2[y++]=temp[3];
	w++;
	y=0;
	convert_hex_bin(stream[w],temp);
	min1[y++]=temp[0];
	min1[y++]=temp[1];
	min1[y++]=temp[2];
	min1[y++]=temp[3];
	w++;
	convert_hex_bin(stream[w],temp);
	min1[y++]=temp[0];
	min1[y++]=temp[1];
	min1[y++]=temp[2];
	min1[y++]=temp[3];
	w++;
	convert_hex_bin(stream[w],temp);
	min1[y++]=temp[0];
	min1[y++]=temp[1];
	min1[y++]=temp[2];
	min1[y++]=temp[3];
	w++;
	convert_hex_bin(stream[w],temp);
	min1[y++]=temp[0];
	min1[y++]=temp[1];
	min1[y++]=temp[2];
	min1[y++]=temp[3];
	w++;
	convert_hex_bin(stream[w],temp);
	min1[y++]=temp[0];
	min1[y++]=temp[1];
	min1[y++]=temp[2];
	min1[y++]=temp[3];
	w++;
	convert_hex_bin(stream[w],temp);
	min1[y++]=temp[0];
	min1[y++]=temp[1];
	min1[y++]=temp[2];
	min1[y++]=temp[3];
	w=w+3;
	nam_info->ipch=(int)((int)stream[w]*256+(int)stream[w+1]*16+(int)stream[w+2]);
	w=w+4;
	nam_info->olc=(int)stream[w];
	w=w+2;
	nam_info->gim=(int)stream[w];
	sprintf(tempmin,"          ");
	convert_min_to_phone(min1,min2,tempmin);
	sprintf(nam_info->areacode,"   ");
	sprintf(nam_info->prefix,"   ");
	sprintf(nam_info->number,"    ");
	
	sprintf(nam_info->areacode,"%c%c%c",tempmin[0],tempmin[1],tempmin[2]);
	sprintf(nam_info->prefix,"%c%c%c",tempmin[3],tempmin[4],tempmin[5]);
	sprintf(nam_info->number,"%c%c%c%c",tempmin[6],tempmin[7],tempmin[8],tempmin[9]);
	
}

// NAMs must be written in order 1-5
// NAM1 sets firstwrite to 1 so that write_nam_init() is called
// NAM5 sets lastwrite to 1 so that write_nam_finish() is called
// The write memory call in this function is different than normal
// write memory.  This one calls C1,F3,B5 which is the get rss call.
// I have tried removing the C1,F3,B5 but that causes the function to
// not actually write the NAM.  Because this function calls the get RSS
// there are values being returned to the ctek from the Oki.  I have
// tried expecting values back on every C1,F3,B5 write but that causes
// the function to hang because it does not always receive back a value.
// Due to this problem I wrote a function clearbuffer() to get rid of
// any unwanted values that could mess up any future read() call.

void write_nam(struct nam nam_info,byte NAM)

{
	byte CURRENT_ADDRESS[6],stream[65],value[4],tempsidhex;
	byte sidhex[3],achex[6],temphex[10],result[3];
	int w,x,y,prefix,number,bit,tempipch,tempsid,acnum;
	int phonebin[32],temp[6],tempac[5];
	int firstwrite=0;
	int lastwrite=0;
	char chksumm;

	unsigned int mask;
	byte WRITE_MEM[6] = {0xC1,0xF3,0xB5,0xC1,0xF3,0xB6};
	byte FIRST_WRITE[3]={0xC1,0xF3,0xB6};
	switch(NAM) {
		case NAM1:
			CURRENT_ADDRESS[0]=0xC1;
			CURRENT_ADDRESS[1]=0xFA;
			CURRENT_ADDRESS[2]=0xB0;
			CURRENT_ADDRESS[3]=0xC1;
			CURRENT_ADDRESS[4]=0xF2;
			CURRENT_ADDRESS[5]=0xBB;
			firstwrite=1;
			break;
		case NAM2:
			CURRENT_ADDRESS[0]=0xC1;
			CURRENT_ADDRESS[1]=0xFA;
			CURRENT_ADDRESS[2]=0xB2;
			CURRENT_ADDRESS[3]=0xC1;
			CURRENT_ADDRESS[4]=0xFE;
			CURRENT_ADDRESS[5]=0xBB;
			break;
		case NAM3:
			CURRENT_ADDRESS[0]=0xC1;
			CURRENT_ADDRESS[1]=0xFA;
			CURRENT_ADDRESS[2]=0xB5;
			CURRENT_ADDRESS[3]=0xC1;
			CURRENT_ADDRESS[4]=0xFA;
			CURRENT_ADDRESS[5]=0xBB;
			break;
		case NAM4:
			CURRENT_ADDRESS[0]=0xC1;
			CURRENT_ADDRESS[1]=0xFA;
			CURRENT_ADDRESS[2]=0xB8;
			CURRENT_ADDRESS[3]=0xC1;
			CURRENT_ADDRESS[4]=0xF6;
			CURRENT_ADDRESS[5]=0xBB;
			break;
		case NAM5:
			CURRENT_ADDRESS[0]=0xC1;
			CURRENT_ADDRESS[1]=0xFA;
			CURRENT_ADDRESS[2]=0xBB;
			CURRENT_ADDRESS[3]=0xC1;
			CURRENT_ADDRESS[4]=0xF2;
			CURRENT_ADDRESS[5]=0xBB;
			lastwrite=1;
			break;
	}
	y=0;
	stream[y++]=0xC1;
	stream[y++]=0xF0;
	tempsid=nam_info.sid/256;
	checksumstream[streamlen++]=(byte)tempsid;
	stream[y++]=(byte)tempsid+0xB0;
	tempsid=nam_info.sid%256;
	tempsidhex=(byte)tempsid;
	checksumstream[streamlen++]=(byte)tempsid;
	convert_hex_twohex(sidhex,tempsidhex);
	stream[y++]=0xC1;
	stream[y++]=sidhex[0];
	stream[y++]=sidhex[1];
	tempac[0]=(int)nam_info.areacode[0]-48;
	if(tempac[0]==0)
		tempac[0]=9;
	else
		tempac[0]--;
	tempac[1]=(int)nam_info.areacode[1]-48;
	if(tempac[1]==0)
		tempac[1]=9;
	else
		tempac[1]--;
	tempac[2]=(int)nam_info.areacode[2]-48;
	if(tempac[2]==0)
		tempac[2]=9;
	else
		tempac[2]--;
	acnum=tempac[0]*100+tempac[1]*10+tempac[2];
	achex[0]=(byte)(acnum/256);
	achex[1]=(byte)(acnum-((acnum/256)*256))/16;
	achex[2]=(byte)(acnum-(achex[0]*256)-(achex[1]*16));
	checksumstream[streamlen++]=achex[0]*16+achex[1];
	stream[y++]=0xC1;
	stream[y++]=achex[0]+0xF0;
	stream[y++]=achex[1]+0xB0;
	stream[y++]=0xC1;
	stream[y++]=achex[2]+0xF0;
	temp[0]=(int)nam_info.prefix[0]-48;
	if(temp[0]==0)
		temp[0]=9;
	else
		temp[0]--;
	temp[1]=(int)nam_info.prefix[1]-48;
	if(temp[1]==0)
		temp[1]=9;
	else
		temp[1]--;
	temp[2]=(int)nam_info.prefix[2]-48;
	if(temp[2]==0)
		temp[2]=9;
	else
		temp[2]--;
	prefix=temp[0]*100+temp[1]*10+temp[2];
	mask=0x800;
	w=0;
	for(x=0;x<12;x++)
	{
		bit=(mask & prefix) ? 1 : 0;
		if(x>1) {
			phonebin[w]=bit;
			w++;
		}
		mask >>=1;
	}
	convert_hex_bin((nam_info.number[0]-48),temp);
	phonebin[w++]=temp[0];
	phonebin[w++]=temp[1];
	phonebin[w++]=temp[2];
	phonebin[w++]=temp[3];
	temp[0]=(int)nam_info.number[1]-48;
	if(temp[0]==0)
		temp[0]=9;
	else
		temp[0]--;
	temp[1]=(int)nam_info.number[2]-48;
	if(temp[1]==0)
		temp[1]=9;
	else
		temp[1]--;
	temp[2]=(int)nam_info.number[3]-48;
	if(temp[2]==0)
		temp[2]=9;
	else
		temp[2]--;
	number=temp[0]*100+temp[1]*10+temp[2];
	mask=0x800;
	for(x=0;x<12;x++)
	{
		bit=(mask & number) ? 1 : 0;
		if(x>1) {
			phonebin[w]=bit;
			w++;
		}
		mask >>=1;
	}
	x=0;
	for(w=0;w<6;w++)
	{
		temphex[w]=(byte)phonebin[x]*8+phonebin[x+1]*4+phonebin[x+2]*2+phonebin[x+3];
		x=x+4;
	}
	
	checksumstream[streamlen++]=temphex[0]+achex[2]*16;
	checksumstream[streamlen++]=16*temphex[1]+temphex[2];
	checksumstream[streamlen++]=16*temphex[3]+temphex[4];
	checksumstream[streamlen++]= 16*temphex[5];
	stream[y++]=temphex[0]+0xB0;
	stream[y++]=0xC1;
	stream[y++]=temphex[1]+0xF0;
	stream[y++]=temphex[2]+0xB0;
	stream[y++]=0xC1;
	stream[y++]=temphex[3]+0xF0;
	stream[y++]=temphex[4]+0xB0;
	stream[y++]=0xC1;
	stream[y++]=temphex[5]+0xF0;
	stream[y++]=0xB0;
	tempipch=nam_info.ipch/256;
	stream[y++]=0xC1;
	stream[y++]=0xF0;
	checksumstream[streamlen++]=(byte)tempipch;
	stream[y++]=(byte)tempipch+0xB0;
	tempipch=(nam_info.ipch-((nam_info.ipch/256)*256));
	checksumstream[streamlen++]=(byte)tempipch;
	convert_hex_twohex(sidhex,(byte)tempipch);
	stream[y++]=0xC1;
	stream[y++]=sidhex[0];
	stream[y++]=sidhex[1];
	stream[y++]=0xC1;
	checksumstream[streamlen++]=(byte)nam_info.olc;
	convert_hex_twohex(sidhex,(byte)nam_info.olc);
	stream[y++]=sidhex[0];
	stream[y++]=sidhex[1];
	stream[y++]=0xC1;
	checksumstream[streamlen++]=(byte)nam_info.gim;
	convert_hex_twohex(sidhex,(byte)nam_info.gim);
	stream[y++]=sidhex[0];
	stream[y++]=sidhex[1];
	y=0;
	if(firstwrite==1) {
		write_nam_init();
	}
	for(x=0;x<11;x++)
	{
		value[0]=stream[y];
		value[1]=stream[y+1];
		value[2]=stream[y+2];
		y=y+3;
		if(!firstwrite) {
			ct_write(&WRITE_MEM,sizeof(WRITE_MEM));
		}
		else {
			firstwrite=0;
			ct_write(&FIRST_WRITE,sizeof(FIRST_WRITE));
		}
		ct_write(&CURRENT_ADDRESS,sizeof(CURRENT_ADDRESS));
		ct_write(&value,sizeof(value));
		if(CURRENT_ADDRESS[4]>0xFB) {
			CURRENT_ADDRESS[2]=CURRENT_ADDRESS[2]+0x01;
			CURRENT_ADDRESS[4]=0xF0+(0x03-(0xFF-CURRENT_ADDRESS[4]));
		}
		else
			CURRENT_ADDRESS[4]=CURRENT_ADDRESS[4]+0x04;
	}
	if(lastwrite)
		write_nam_finish();
sleep(1);  // Needs to be paused between writes or NAM corrupted (? some bug ?)	
}

//Turn off write protect - NECESSARY
void write_nam_init()
{
	byte COMMAND1[3] = {0xC1,0xF3,0xB6};
	byte COMMAND2[3] = {0xC1,0xF7,0xB0};
	byte COMMAND3[3] = {0xC1,0xF0,0xB5};
	byte COMMAND4[3] = {0xC1,0xF0,0xB1};
	
	ct_write(&COMMAND1,sizeof(COMMAND1));
	ct_write(&COMMAND2,sizeof(COMMAND2));
	ct_write(&COMMAND3,sizeof(COMMAND3));
	ct_write(&COMMAND4,sizeof(COMMAND4));
}

//Write the rest of the values used for the NAM and calculate the new
//checksum.  Turn write protect back on.

void write_nam_finish()
{
	byte WRITE_MEM[3] = {0xC1,0xF3,0xB6};
	byte WRITE_PROT[3] = {0xC1,0xF3,0xB6};
	byte CURRENT_ADDRESS[6],checksum[2],value[3];
	byte newchecksum;
	int x;
	
	value[0]=0xC1;
	value[1]=0xF0;
	value[2]=0xBA;
	checksumstream[streamlen++]=0x0A;
	CURRENT_ADDRESS[0]=0xC1;
	CURRENT_ADDRESS[1]=0xFA;
	CURRENT_ADDRESS[2]=0xBD;
	CURRENT_ADDRESS[3]=0xC1;
	CURRENT_ADDRESS[4]=0xFE;
	CURRENT_ADDRESS[5]=0xBB;
	
	ct_write(&WRITE_MEM,sizeof(WRITE_MEM));
	ct_write(&CURRENT_ADDRESS,sizeof(CURRENT_ADDRESS));
	ct_write(&value,sizeof(value));
	value[1]=0xFA;
	value[2]=0xBA;
	checksumstream[streamlen++]=0xAA;
	CURRENT_ADDRESS[2]=0xBE;
	CURRENT_ADDRESS[4]=0xF2;
	ct_write(&WRITE_MEM,sizeof(WRITE_MEM));
	ct_write(&CURRENT_ADDRESS,sizeof(CURRENT_ADDRESS));
	ct_write(&value,sizeof(value));
	CURRENT_ADDRESS[4]=0xF6;
	checksumstream[streamlen++]=0xAA;
	ct_write(&WRITE_MEM,sizeof(WRITE_MEM));
	ct_write(&CURRENT_ADDRESS,sizeof(CURRENT_ADDRESS));
	ct_write(&value,sizeof(value));
	value[1]=0xF0;
	value[2]=0xBE;
	checksumstream[streamlen++]=0x0E;
	CURRENT_ADDRESS[4]=0xFA;
	ct_write(&WRITE_MEM,sizeof(WRITE_MEM));
	ct_write(&CURRENT_ADDRESS,sizeof(CURRENT_ADDRESS));
	ct_write(&value,sizeof(value));
	value[2]=0xB0;
	checksumstream[streamlen++]=0x00;
	CURRENT_ADDRESS[4]=0xFE;
	ct_write(&WRITE_MEM,sizeof(WRITE_MEM));
	ct_write(&CURRENT_ADDRESS,sizeof(CURRENT_ADDRESS));
	ct_write(&value,sizeof(value));
	value[1]=0xFA;
	value[2]=0xBA;
	checksumstream[streamlen++]=0xAA;
	CURRENT_ADDRESS[2]=0xBF;
	CURRENT_ADDRESS[4]=0xF2;
	ct_write(&WRITE_MEM,sizeof(WRITE_MEM));
	ct_write(&CURRENT_ADDRESS,sizeof(CURRENT_ADDRESS));
	ct_write(&value,sizeof(value));
	checksumstream[streamlen++]=0xAA;
	CURRENT_ADDRESS[4]=0xF6;
	ct_write(&WRITE_MEM,sizeof(WRITE_MEM));
	ct_write(&CURRENT_ADDRESS,sizeof(CURRENT_ADDRESS));
	ct_write(&value,sizeof(value));
	checksumstream[streamlen++]=0xAA;
	CURRENT_ADDRESS[4]=0xFA;
	ct_write(&WRITE_MEM,sizeof(WRITE_MEM));
	ct_write(&CURRENT_ADDRESS,sizeof(CURRENT_ADDRESS));
	ct_write(&value,sizeof(value));
	checksumstream[streamlen++]=0xAA;
	CURRENT_ADDRESS[4]=0xFE;
	ct_write(&WRITE_MEM,sizeof(WRITE_MEM));
	ct_write(&CURRENT_ADDRESS,sizeof(CURRENT_ADDRESS));
	ct_write(&value,sizeof(value));
	value[1]=0xF0;
	value[2]=0xB0;
	checksumstream[streamlen++]=0x00;
	checksumstream[streamlen++]=oldchecksum;
	checksumstream[streamlen++]=0x55;
	newchecksum=(oldchecksum-genchecksum());
	CURRENT_ADDRESS[1]=0xFB;
	CURRENT_ADDRESS[2]=0xB0;
	CURRENT_ADDRESS[4]=0xF2;
	ct_write(&WRITE_MEM,sizeof(WRITE_MEM));
	ct_write(&CURRENT_ADDRESS,sizeof(CURRENT_ADDRESS));
	ct_write(&value,sizeof(value));
	convert_hex_twohex(checksum,newchecksum);
	value[1]=checksum[0]; 
	value[2]=checksum[1];
	CURRENT_ADDRESS[4]=0xF6;
	ct_write(&WRITE_MEM,sizeof(WRITE_MEM));
	ct_write(&CURRENT_ADDRESS,sizeof(CURRENT_ADDRESS));
	ct_write(&value,sizeof(value));
	value[1]=0xF5;
	value[2]=0xB5;
	CURRENT_ADDRESS[4]=0xFA;
	ct_write(&WRITE_MEM,sizeof(WRITE_MEM));
	ct_write(&CURRENT_ADDRESS,sizeof(CURRENT_ADDRESS));
	ct_write(&value,sizeof(value));
	value[1]=0xF0;
	value[2]=0xB0;
	CURRENT_ADDRESS[1]=0xF7;
	CURRENT_ADDRESS[2]=0xB0;
	CURRENT_ADDRESS[4]=0xF0;
	CURRENT_ADDRESS[5]=0xB5;
	ct_write(&WRITE_PROT,sizeof(WRITE_PROT));
	ct_write(&CURRENT_ADDRESS,sizeof(CURRENT_ADDRESS));
	ct_write(&value,sizeof(value));
	clearbuffer();
}

int set_channel(int channel)			  
{
	byte SET_CHANNEL[3]={0xC1,0xF0,0xB9};
	byte CHANNEL_SETTING1[3]={0xC1,0xF0,0xB0};
	byte CHANNEL_SETTING2[3]={0xC1,0xF0,0xB0};
	byte twohex[2];
	int multiplier;
	
	multiplier=(channel/256);
	ct_write(&SET_CHANNEL,sizeof(SET_CHANNEL));
	convert_hex_twohex(twohex,((byte)(channel-(256*multiplier))));
	CHANNEL_SETTING1[1]=twohex[0];
	CHANNEL_SETTING1[2]=twohex[1];
	CHANNEL_SETTING2[2]=(byte)((int)0xB0+multiplier);
	ct_write(&CHANNEL_SETTING1,sizeof(CHANNEL_SETTING1));
	ct_write(&CHANNEL_SETTING2,sizeof(CHANNEL_SETTING2));
	return channel;
}

bool get_fcc(byte MODE,byte *stream)
{
	byte FCC_SETUP[3] = {0xC1,0xF1,0xB4};
	byte FCC_ABORT[3] = {0xC1,0xF3,0xB8};
	byte result[3],fccstream[15],temp2[15];
	
	switch(MODE) {
		case OKI_FCC_SETUP:
			ct_write(&FCC_SETUP,sizeof(FCC_SETUP));
			break;
		case OKI_FCC_ABORT: 
			ct_write(&FCC_ABORT,sizeof(FCC_ABORT));
			ct_read(&result,sizeof(result));
			break;
		case OKI_FCC_GET:
			ct_write(&FCC_SETUP,sizeof(FCC_SETUP));
			ct_read(&fccstream,sizeof(fccstream));
			stream[0]=fccstream[1]-0xC0;
			stream[1]=fccstream[2]-0xB0;
			stream[2]=fccstream[4]-0xC0;
			stream[3]=fccstream[5]-0xB0;
			stream[4]=fccstream[7]-0xC0;
			stream[5]=fccstream[8]-0xB0;
			stream[6]=fccstream[10]-0xC0;
			stream[7]=fccstream[11]-0xB0;
			stream[8]=fccstream[13]-0xC0;
			stream[9]=fccstream[14]-0xB0;
			
			if(fccstream[1]>0xC3)
			{
				ct_read(&temp2,sizeof(temp2));
				stream[10]=temp2[1]-0xC0;
				stream[11]=temp2[2]-0xB0;
				stream[12]=temp2[4]-0xC0;
				stream[13]=temp2[5]-0xB0;
				stream[14]=temp2[7]-0xC0;
				stream[15]=temp2[8]-0xB0;
				stream[16]=temp2[10]-0xC0;
				stream[17]=temp2[11]-0xB0;
				stream[18]=temp2[13]-0xC0;
				stream[19]=temp2[14]-0xB0;
				return TRUE;
			}
			break;
	}
	return FALSE;
}
bool decode_fcc(byte *stream,struct fccval *focc)
{
	int length,temp[5],min2[10],min1[24],tempvmac[3],tempchan[11];
	char tempmin[32];
	char local[5],ordq[3],order[5];
	int x,y;
	
//	printf("%01x%01x%01x%01x%01x%01x%01x%01x%01x%01x",stream[0],stream[1],stream[2],stream[3],stream[4],stream[5],stream[6],stream[7],stream[8],stream[9]);	
//	printf("%01x%01x%01x%01x%01x%01x%01x%01x%01x%01x\n",stream[10],stream[11],stream[12],stream[13],stream[14],stream[15],stream[16],stream[17],stream[18],stream[19]);	
	focc->scc=0;
	focc->dcc=0;
	focc->order=0;
	focc->chan=0;
	focc->vmac=0;
	focc->ordq=0;
	focc->prefix[0]='\0';
	focc->areacode[0]='\0';
	focc->number[0]='\0';
	for(x=0;x<24;x++)
		min1[x]=0;
	for(x=0;x<10;x++)
		min2[x]=0;
	if(stream[0]<0x04)
		length=10;
	else if((stream[0]>=0x04) && (stream[0]<=0x08))
		length=20;
	else
		return FALSE;
	switch((int)stream[0]){
		case 0: focc->dcc=0;
			break;
		case 1: focc->dcc=1;
			break;
		case 2: focc->dcc=2;
			break;
		case 3: focc->dcc=3;
			break;
		case 4: focc->dcc=0;
			break;
		case 5: focc->dcc=1;
			break;
		case 6: focc->dcc=2;
			break;
		case 7: focc->dcc=3;
			break;
	}
	y=0;
	for(x=0;x<6;x++)
	{
		convert_hex_bin(stream[x+1],temp);
		min1[y++]=temp[0];
		min1[y++]=temp[1];
		min1[y++]=temp[2];
		min1[y++]=temp[3];
	}
	if(length==20) {
		if(stream[10]<0x08)
			return FALSE;
		focc->scc=((int)stream[10])-8;
		y=0;	
		for(x=11;x<14;x++)
		{
			convert_hex_bin(stream[x],temp);
			min2[y]=temp[0];
			min2[y+1]=temp[1];
			if((y+2)<10)
				min2[y+2]=temp[2];
			if((y+3)<10)
				min2[y+3]=temp[3];
			y+=4;
		}
		if(focc->scc==3) {
			local[0]=temp[3];
			convert_hex_bin(stream[14],temp);
			local[1]=temp[0];
			local[2]=temp[1];
			local[3]=temp[2];
			local[4]=temp[3];
			convert_hex_bin(stream[15],temp);
			ordq[0]=temp[0];
			ordq[1]=temp[1];
			ordq[2]=temp[2];
			order[0]=temp[0];
			convert_hex_bin(stream[16],temp);
			order[1]=temp[0];
			order[2]=temp[1];
			order[3]=temp[2];
			order[4]=temp[3];
			focc->local=((local[0]*16)+(local[1]*8)+(local[2]*4)+(local[3]*2)+(local[4]));
			focc->ordq=((ordq[0]*4)+(ordq[1]*2)+(ordq[2]));
			focc->order=((order[0]*16)+(order[1]*8)+(order[2]*4)+(order[3]*2)+(order[4]));
		}
		else {
			tempvmac[0]=temp[2];
			tempvmac[1]=temp[3];
			convert_hex_bin(stream[14],temp);
			tempvmac[2]=temp[0];
			tempchan[0]=temp[1];
			tempchan[1]=temp[2];
			tempchan[2]=temp[3];
			convert_hex_bin(stream[15],temp);
			tempchan[3]=temp[0];
			tempchan[4]=temp[1];
			tempchan[5]=temp[2];
			tempchan[6]=temp[3];
			convert_hex_bin(stream[16],temp);
			tempchan[7]=temp[0];
			tempchan[8]=temp[1];
			tempchan[9]=temp[2];
			tempchan[10]=temp[3];
			focc->vmac=((tempvmac[0]*4)+(tempvmac[1]*2)+(tempvmac[2]*1));
			focc->chan=((tempchan[0]*1024)+(tempchan[1]*512)+(tempchan[2]*256)+(tempchan[3]*128)+(tempchan[4]*64)+(tempchan[5]*32)+(tempchan[6]*16)+(tempchan[7]*8)+(tempchan[8]*4)+(tempchan[9]*2)+(tempchan[10]*1));
		}
		convert_min_to_phone(min1,min2,tempmin);
		sprintf(focc->areacode,"%c%c%c",tempmin[0],tempmin[1],tempmin[2]);
		sprintf(focc->prefix,"%c%c%c",tempmin[3],tempmin[4],tempmin[5]);
		sprintf(focc->number,"%c%c%c%c",tempmin[6],tempmin[7],tempmin[8],tempmin[9]);
	}
	
	return TRUE;
}
void convert_min_to_phone(int *min1, int *min2, char *min)
{
	int phone[10];
	int minone[3],mintwo;
	int temp,temp2;
	
	mintwo=(min2[0]*512)+(min2[1]*256)+(min2[2]*128)+(min2[3]*64)+(min2[4]*32)+(min2[5]*16)+(min2[6]*8)+(min2[7]*4)+(min2[8]*2)+(min2[9]*1);
	phone[2]=mintwo%10+1;
	phone[1]=mintwo%100/10+1;
	phone[0]=mintwo%1000/100+1;
	
	if(phone[0]>=10)
		phone[0]=phone[0]-10;
	
	if(phone[1]>=10)
		phone[1]=phone[1]-10;
	
	if(phone[2]>=10)
		phone[2]=phone[2]-10;
	
	
	minone[0]=((min1[0]*512)+(min1[1]*256)+(min1[2]*128)+(min1[3]*64)+(min1[4]*32)+(min1[5]*16)+(min1[6]*8)+(min1[7]*4)+(min1[8]*2)+(min1[9]*1));
	minone[1]=((min1[10]*8)+(min1[11]*4)+(min1[12]*2)+(min1[13]*1));
	minone[2]=((min1[14]*512)+(min1[15]*256)+(min1[16]*128)+(min1[17]*64)+(min1[18]*32)+(min1[19]*16)+(min1[20]*8)+(min1[21]*4)+(min1[22]*2)+(min1[23]*1));
	
	phone[5]=minone[0]%10+1;
	phone[4]=minone[0]%100/10+1;
	phone[3]=minone[0]%1000/100+1;
	
	if(phone[3]>9)
		phone[3]=phone[3]-10;
	
	if(phone[4]>9)
		phone[4]=phone[4]-10;
	
	if(phone[5]>9)
		phone[5]=phone[5]-10;
	
	phone[6]=minone[1];
	if(phone[6]>9)
		phone[6]=phone[6]-10;
	
	phone[9]=minone[2]%10+1;
	phone[8]=minone[2]%100/10+1;
	phone[7]=minone[2]%1000/100+1;
	
	if(phone[7]>9)
		phone[7]=phone[7]-10;
	
	if(phone[8]>9)
		phone[8]=phone[8]-10;
	
	if(phone[9]>9)
		phone[9]=phone[9]-10;
	
	sprintf(min,"%d%d%d%d%d%d%d%d%d%d",phone[0],phone[1],phone[2],phone[3],phone[4],phone[5],phone[6],phone[7],phone[8],phone[9]);
}
bool get_fvc(byte MODE,byte *stream)
{
	byte FVC_SETUP[3] = {0xC1,0xF1,0xB5};
	byte FVC_ABORT[3] = {0xC1,0xF3,0xB0};
	byte result[3],fvcstream[15];
	
	switch(MODE) {
		case OKI_FVC_SETUP:
			ct_write(&FVC_SETUP,sizeof(FVC_SETUP));
			break;
		case OKI_FVC_ABORT: 
			ct_write(&FVC_ABORT,sizeof(FVC_ABORT));
			ct_read(&result,sizeof(result));
			break;
		case OKI_FVC_GET: 
			ct_write(&FVC_SETUP,sizeof(FVC_SETUP));
			ct_read(&fvcstream,sizeof(fvcstream));
			stream[0]=fvcstream[1]-0xC0;
			stream[1]=fvcstream[2]-0xB0;
			stream[2]=fvcstream[4]-0xC0;
			stream[3]=fvcstream[5]-0xB0;
			stream[4]=fvcstream[7]-0xC0;
			stream[5]=fvcstream[8]-0xB0;
			stream[6]=fvcstream[10]-0xC0;
			stream[7]=fvcstream[11]-0xB0;
			stream[8]=fvcstream[13]-0xC0;
			stream[9]=fvcstream[14]-0xB0;
			return TRUE;
			break;
	}
	return FALSE;
}
bool decode_fvc(byte *stream,struct fvcval *fvc)
{
	int temp[5],tempvmac[3],tempchan[11],temppscc[2];
	char local[6],ordq[3],order[5];
	
	fvc->ordq=0;
	fvc->order=0;
	fvc->vmac=0;
	fvc->chan=0;
	fvc->scc=((int)stream[0])-8;
	
	convert_hex_bin(stream[1],temp);
	temppscc[0]=temp[0];
	temppscc[1]=temp[1];
	fvc->pscc=((temppscc[0]*2)+(temppscc[1]));
	if(fvc->scc==3) {
		convert_hex_bin(stream[3],temp);
		local[0]=temp[2];
		local[1]=temp[3];
		convert_hex_bin(stream[4],temp);
		local[2]=temp[0];
		local[3]=temp[1];
		local[4]=temp[2];
		local[5]=temp[3];
		convert_hex_bin(stream[5],temp);
		ordq[0]=temp[0];
		ordq[1]=temp[1];
		ordq[2]=temp[2];
		order[0]=temp[3];
		convert_hex_bin(stream[6],temp);
		order[1]=temp[0];
		order[2]=temp[1];
		order[3]=temp[2];
		order[4]=temp[3];
		fvc->local=((local[0]*16)+(local[1]*8)+(local[2]*4)+(local[3]*2)+(local[4]));
		fvc->ordq=((ordq[0]*4)+(ordq[1]*2)+(ordq[2]));
		fvc->order=((order[0]*16)+(order[1]*8)+(order[2]*4)+(order[3]*2)+(order[4]));
	}
	else {
		convert_hex_bin(stream[3],temp);
		tempvmac[0]=temp[2];
		tempvmac[1]=temp[3];
		convert_hex_bin(stream[4],temp);
		tempvmac[2]=temp[0];
		tempchan[0]=temp[1];
		tempchan[1]=temp[2];
		tempchan[2]=temp[3];
		convert_hex_bin(stream[5],temp);
		tempchan[3]=temp[0];
		tempchan[4]=temp[1];
		tempchan[5]=temp[2];
		tempchan[6]=temp[3];
		convert_hex_bin(stream[6],temp);
		tempchan[7]=temp[0];
		tempchan[8]=temp[1];
		tempchan[9]=temp[2];
		tempchan[10]=temp[3];
		fvc->vmac=((tempvmac[0]*4)+(tempvmac[1]*2)+(tempvmac[2]*1));
		fvc->chan=((tempchan[0]*1024)+(tempchan[1]*512)+(tempchan[2]*256)+(tempchan[3]*128)+(tempchan[4]*64)+(tempchan[5]*32)+(tempchan[6]*16)+(tempchan[7]*8)+(tempchan[8]*4)+(tempchan[9]*2)+(tempchan[10]*1));
	}
	return TRUE;
}

bool get_romversion(char *romver)
{
	byte ROMVERSION[3]={0xC1,0xF1,0xB7};
	byte okiresponse[3];
	
	ct_write(&ROMVERSION, sizeof(ROMVERSION));
	ct_read(&okiresponse,sizeof(okiresponse));
	romver[0]=(char)(okiresponse[1]-0xC0)+48;
	romver[1]=(char)(okiresponse[2]-0xB0)+48;
	ct_read(&okiresponse,sizeof(okiresponse));
	romver[2]=(char)okiresponse[1]-0xC0+48;
	romver[3]=(char)okiresponse[2]-0xB0+48;
	romver[4]='\0';
	return TRUE;
}
void decode_order(int order,int ordq,char *type)
{
	
	if(ordq==0)
	{
		switch(order) {
			case 0:  
				sprintf(type,"page");              
				break;
			case 1:  
				sprintf(type,"alert");              
				break;
			case 3:  
				sprintf(type,"release");              
				break;
			case 4:  
				sprintf(type,"reorder");              
				break;
			case 6:  
				sprintf(type,"stop alert");              
				break;
			case 7:  
				sprintf(type,"audit");              
				break;
			case 8:  
				sprintf(type,"send called address");              
				break;
			case 9:  
				sprintf(type,"intercept");              
				break;
			case 10:  
				sprintf(type,"maintenance");              
				break;
			case 11:  
				sprintf(type,"change to power level 0");              
				break;
			case 12:  
				sprintf(type,"directed retry");              
				break;
			case 13:  
				sprintf(type,"non-auton reg: off");              
				break;
			case 30:  
				sprintf(type,"local control");              
				break;
			default:
				sprintf(type,"reserved: %d,0",order);
				break;
		}
	}
	else 
		if(order==11) {
			sprintf(type,"change to power level %d",ordq);
		}
		else
			if(order==12)
			{
				sprintf(type,"directred retry");
			}
			else
				if(order==13)
				{
					if(ordq==0)
						sprintf(type,"non-auton reg: off");
					else if(ordq==1)
						sprintf(type,"non-auton reg: on");
					else if(ordq==2)
						sprintf(type,"auton reg: off");
					else if(ordq==3)
						sprintf(type,"auton reg: on");
					else
						sprintf(type,"unknown %d reg",ordq);
				}
// sprintf(type,"reserved: %d,%d",order,ordq);
}


byte genchecksum()
{ 
	byte sum;
	int i,x;
	
	sum = 0;
	for(i=(int)0x43,x=0;i>0;i--,x++)
	{
		sum+=checksumstream[x];
	}
	return(sum);
}

// void 
keylock_pass(bool type, char *keyPass)
{
	int x ,keys,times;
	byte WRITE_MEM[3] = {0xc1,0xf3,0xb6};
	byte READ_MEM[3] = {0xC1,0xF1,0xB9};
	byte result[3];
	byte i_adress[6]={0xc1,0xfb,0xbf,0xc1,0xf5,0xbf};
	byte adress[4][6] = {
		{0xC1,0xFB,0xBF,0xC1,0xF6,0xB0},
		{0xC1,0xFB,0xBF,0xC1,0xF6,0xB1},
		{0xC1,0xFB,0xBF,0xc1,0xf6,0xb2},
		{0xc1,0xFB,0xBF,0xc1,0xf6,0xb3},
	};
	
	if(type){
		int y=0;
		ct_write(&READ_MEM,sizeof(READ_MEM));
		ct_write(&i_adress,sizeof(i_adress)); 
		ct_read(&result,sizeof(result));
		keys=(int)(result[2]-0xb0);
		times=(keys+1)/2;
		for (x=0;x < times; x++){
			ct_write(&READ_MEM,sizeof(READ_MEM));
			ct_write(&adress[x],sizeof(adress[x]));
			ct_read(&result,sizeof(result));
			keyPass[y]=(char)(result[1]-0xc0+48);
			if (keyPass[y] == '0')  keyPass[y]=' ';
			if (keyPass[y] == ':')  keyPass[y]='0';
			keyPass[y+1]=(char)(result[2]-0xb0+48);
			if (keyPass[y+1] == '0') keyPass[y+1]=' ';
			if (keyPass[y+1] == ':') keyPass[y+1]='0';
			y+=2;
		}
		keyPass[keys]='\0';
	}
	else{
		int y=0;
		byte VAL[3];
		VAL[0]=0xc1;
		keys=strlen(keyPass);
		VAL[1]=0xf0; VAL[2]=((byte)keys)+0xb0;
		ct_write(&WRITE_MEM,sizeof(WRITE_MEM));
		ct_write(&i_adress,sizeof(i_adress));
		ct_write(&VAL,sizeof(VAL));
		times=(keys+1)/2;
		for(x=0;x < times; x++){
			ct_write(&WRITE_MEM,sizeof(WRITE_MEM));
			ct_write(&adress[x],sizeof(adress[x]));
			VAL[1]=enc_paskey(keyPass[y],0xF0);
			VAL[2]=enc_paskey(keyPass[y+1],0xB0);
			ct_write(&VAL,sizeof(VAL));
			y+=2;
		}
	}
}
byte enc_paskey(char entry,byte mask)
{
	switch (entry){
		case '0': return (0x0A+mask); break;
		case '1': return (0x01+mask); break;
		case '2': return (0x02+mask); break;
		case '3': return (0x03+mask); break;
		case '4': return (0x04+mask); break;
		case '5': return (0x05+mask); break;
		case '6': return (0x06+mask); break;
		case '7': return (0x07+mask); break;
		case '8': return (0x08+mask); break;
		case '9': return (0x09+mask); break;
		default : return (0x00+mask); break;
	}
}

int find_fcc(int carrier)
{
// 0 - both carriers
// 1 - a carrier only
// 2 - b carrier only
	
	int strongsignal,strongchan,signal,chan;
	
	strongsignal=signal=0;
	strongchan=313;
	
	if (carrier==0) 
		for(chan=313;chan<354;chan++) 
		{
			set_channel(chan);
			signal=get_rss();
			if(signal>strongsignal) 
			{
				strongsignal=signal;
				strongchan=chan;
			}
		}
	
	
	if (carrier==1) 
		for(chan=313;chan<333;chan++) 
		{
			set_channel(chan);
			signal=get_rss();
			if(signal>strongsignal) 
			{
				strongsignal=signal;
				strongchan=chan;
			}
		}
	
	if (carrier==2) 
		for(chan=334;chan<354;chan++) 
		{
			set_channel(chan);
			signal=get_rss();
			if(signal>strongsignal) 
			{
				strongsignal=signal;
				strongchan=chan;
			}
		}
	
	return strongchan;
}
float channel_to_ffreq(int channel)
{
	float fwd;
	fwd=(float) (channel*.030)+870;
	return fwd;
}
float channel_to_rfreq(int channel)
{
	float rev;
	rev=(float) (channel*.030)+825;
	return rev;
}



dealer_pass(bool type , char *progpwd)
{
	int x, y=0;
	byte reply[3];
	byte WMEM[3]={0xc1,0xf3,0xb6};
	byte RMEM[3]={0xc1,0xf1,0xb9};
	byte BLOCK[5][6]= {
		{0xc1,0xfb,0xbe,0xc1,0xfd,0xba},
		{0xc1,0xfb,0xbe,0xc1,0xfd,0xbb},
		{0xc1,0xfb,0xbe,0xc1,0xfd,0xbc},	
		{0xc1,0xfb,0xbe,0xc1,0xfd,0xbd},
		{0xc1,0xfb,0xbe,0xc1,0xfd,0xbe},
	};
	if (type){
		for(x=0; x < 5; x++){
			ct_write(&RMEM,sizeof(RMEM));
			ct_write(&BLOCK[x],sizeof(BLOCK[x]));
			ct_read(&reply,sizeof(reply));
			progpwd[y]=(char)(reply[1]-0xc0+48);
			if (progpwd[y] =='0') progpwd[y]=' ';
			if (progpwd[y] ==':') progpwd[y]='0';
			progpwd[y+1]=(char)(reply[2]-0xb0+48);
			if (progpwd[y+1] == '0') progpwd[y+1]=' ';
			if (progpwd[y+1] == ':') progpwd[y+1]='0';
			y+=2;
		}
		progpwd[10] = '\0';
	}
	else {
		byte VAL[3];
		VAL[0]=0xc1;
		for(x=0;x < 5; x++){
			ct_write(&WMEM,sizeof(WMEM));
			ct_write(&BLOCK[x],sizeof(BLOCK[x]));
			VAL[1]=enc_paskey(progpwd[y],0xF0);
			VAL[2]=enc_paskey(progpwd[y+1],0xB0);
			ct_write(&VAL,sizeof(VAL));
			y+=2;
		}
		
	}
}

adm_pass(bool type,char *admpwd){
	
	int x, y=0;
	byte reply[3];
	byte PMEM[6]={0xc1,0xf7,0xb0,0xc1,0xf0,0xb5};
	byte WMEM[3]={0xc1,0xf3,0xb6};
	byte RMEM[3]={0xc1,0xf1,0xb9};
	byte BLOCK[3][6]= {
		{0xc1,0xfa,0xbf,0xc1,0xf6,0xbb},
		{0xc1,0xfa,0xbf,0xc1,0xfa,0xbb},
		{0xc1,0xfa,0xbf,0xc1,0xfe,0xbb},
	};
	if (type){
		for(x=0; x < 3; x++){
			ct_write(&RMEM,sizeof(RMEM));
			ct_write(&BLOCK[x],sizeof(BLOCK[x]));
			ct_read(&reply,sizeof(reply));
			admpwd[y]=(char)(reply[1]-0xc0+48);
			if (admpwd[y] =='0') admpwd[y]=' ';
			if (admpwd[y] ==':') admpwd[y]='0';
			admpwd[y+1]=(char)(reply[2]-0xb0+48);
			if (admpwd[y+1] == '0') admpwd[y+1]=' ';
			if (admpwd[y+1] == ':') admpwd[y+1]='0';
			y+=2;
		}
		admpwd[7] = '\0';
		return TRUE;
	}
	else {
		byte VAL[3];
		VAL[0]=0xc1;
		VAL[1]=0xf0;
		VAL[2]=0xb1;
		ct_write(&WMEM,sizeof(WMEM));
		ct_write(&PMEM,sizeof(PMEM));
		ct_write(&VAL,sizeof(VAL));
		for(x=0;x < 3; x++){
			ct_write(&WMEM,sizeof(WMEM));
			ct_write(&BLOCK[x],sizeof(BLOCK[x]));
			VAL[1]=enc_paskey(admpwd[y],0xF0);
			VAL[2]=enc_paskey(admpwd[y+1],0xB0);
			ct_write(&VAL,sizeof(VAL));
			y+=2;
		}
		VAL[1]=0xf0;
		VAL[2]=0xb0;
		ct_write(&WMEM,sizeof(WMEM));
		ct_write(&PMEM,sizeof(PMEM));
		ct_write(&VAL,sizeof(VAL));
		return TRUE;
	}
}


