// 4712.c              Avoozl, [dOPEMan], PoTom			1998-99

//////////////////////////////////////////////////////////////////////////
//////       ESN stuff  , this is 4712 firmware specific            //////
//////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include "cteklib.h"

void read_esns(char *value1,char *value2,char *value3,char *value4,char *value5)
{
	int x;
	byte temp[4];
	
	readesn(temp,ESN1);
	sprintf(value1,"%02x%02x%02x%02x",temp[0],temp[1],temp[2],temp[3]);
	for(x=0;x<strlen(value1);x++)
		value1[x]=(char)toupper((int)value1[x]);        
	readesn(temp,ESN2);
	sprintf(value2,"%02x%02x%02x%02x",temp[0],temp[1],temp[2],temp[3]);
	for(x=0;x<strlen(value2);x++)
		value2[x]=(char)toupper((int)value2[x]);        
	readesn(temp,ESN3);
	sprintf(value3,"%02x%02x%02x%02x",temp[0],temp[1],temp[2],temp[3]);
	for(x=0;x<strlen(value3);x++)
		value3[x]=(char)toupper((int)value3[x]);        
	readesn(temp,ESN4);
	sprintf(value4,"%02x%02x%02x%02x",temp[0],temp[1],temp[2],temp[3]);
	for(x=0;x<strlen(value4);x++)
		value4[x]=(char)toupper((int)value4[x]);        
	readesn(temp,ESN5);
	sprintf(value5,"%02x%02x%02x%02x",temp[0],temp[1],temp[2],temp[3]);
	for(x=0;x<strlen(value5);x++)
		value5[x]=(char)toupper((int)value5[x]);        
}

void write_esns(const char *msg1, const char *msg2, const char *msg3, const char *msg4, const char *msg5)
{
	int convertedhex;
	byte hextosend[8];
	int x;
	
	for(x=0;x<8;x++) {	
		convertedhex=checkinput(toupper(msg1[x]));
		hextosend[x]=(byte)convertedhex;
	}
	writeesn(hextosend,ESN1);
	for(x=0;x<8;x++) {	
		convertedhex=checkinput(toupper(msg2[x]));
		hextosend[x]=(byte)convertedhex;
	}
	writeesn(hextosend,ESN2);
	for(x=0;x<8;x++) {	
		convertedhex=checkinput(toupper(msg3[x]));
		hextosend[x]=(byte)convertedhex;
	}
	writeesn(hextosend,ESN3);
	for(x=0;x<8;x++) {	
		convertedhex=checkinput(toupper(msg4[x]));
		hextosend[x]=(byte)convertedhex;
	}
	writeesn(hextosend,ESN4);
	for(x=0;x<8;x++) {	
		convertedhex=checkinput(toupper(msg5[x]));
		hextosend[x]=(byte)convertedhex;
	}
	writeesn(hextosend,ESN5);
}

bool readesn(byte esn[4],byte ESN)
{
	byte GET_ESN1[4][6] = {{0xC1,0xFB,0xBE,0xC1,0xF8,0xBE},{0xC1,0xFB,0xBE,0xC1,0xF8,0xBF},{0xC1,0xFB,0xBE,0xC1,0xF9,0xB0},{0xC1,0xFB,0xBE,0xC1,0xF9,0xB1}};
	byte GET_ESN2[4][6] = {{0xC1,0xFB,0xBE,0xC1,0xF9,0xB3},{0xC1,0xFB,0xBE,0xC1,0xF9,0xB4},{0xC1,0xFB,0xBE,0xC1,0xF9,0xB5},{0xC1,0xFB,0xBE,0xC1,0xF9,0xB6}};
	byte GET_ESN3[4][6] = {{0xC1,0xFB,0xBE,0xC1,0xF9,0xB8},{0xC1,0xFB,0xBE,0xC1,0xF9,0xB9},{0xC1,0xFB,0xBE,0xC1,0xF9,0xBA},{0xC1,0xFB,0xBE,0xC1,0xF9,0xBB}};
	byte GET_ESN4[4][6] = {{0xC1,0xFB,0xBE,0xC1,0xF9,0xBD},{0xC1,0xFB,0xBE,0xC1,0xF9,0xBE},{0xC1,0xFB,0xBE,0xC1,0xF9,0xBF},{0xC1,0xFB,0xBE,0xC1,0xFA,0xB0}};
	byte GET_ESN5[4][6] = {{0xC1,0xFB,0xBE,0xC1,0xFA,0xB2},{0xC1,0xFB,0xBE,0xC1,0xFA,0xB3},{0xC1,0xFB,0xBE,0xC1,0xFA,0xB4},{0xC1,0xFB,0xBE,0xC1,0xFA,0xB5}};
	byte READ_MEM[3] = {0xC1,0xF1,0xB9};
	byte d[3];
	
	ct_write(&READ_MEM,sizeof(READ_MEM));
//Write to the ctek the ESN that we want and read 3 values back
//subtract the 0xC0 and 0xB0, combine the two hex by multiplying the first 
//by 16 and adding the second
	switch(ESN) {
		case ESN1:
			ct_write(&GET_ESN1[0],sizeof(GET_ESN1[0]));
			ct_read(&d,sizeof(d));
			esn[0]=(byte)16*(d[1]-0xC0)+(d[2]-0xB0);
			
			ct_write(&READ_MEM,sizeof(READ_MEM));
			ct_write(&GET_ESN1[1],sizeof(GET_ESN1[1]));
			ct_read(&d,sizeof(d));
			esn[1]=(byte)16*(d[1]-0xC0)+(d[2]-0xB0);
			
			ct_write(&READ_MEM,sizeof(READ_MEM));
			ct_write(&GET_ESN1[2],sizeof(GET_ESN1[2]));
			ct_read(&d,sizeof(d));
			esn[2]=(byte)16*(d[1]-0xC0)+(d[2]-0xB0);
			
			ct_write(&READ_MEM,sizeof(READ_MEM));
			ct_write(&GET_ESN1[3],sizeof(GET_ESN1[3]));
			ct_read(&d,sizeof(d));
			esn[3]=(byte)16*(d[1]-0xC0)+(d[2]-0xB0);
			break;
		case ESN2:
			ct_write(&GET_ESN2[0],sizeof(GET_ESN2[0]));
			ct_read(&d,sizeof(d));
			esn[0]=(byte)16*(d[1]-0xC0)+(d[2]-0xB0);
			
			ct_write(&READ_MEM,sizeof(READ_MEM));
			ct_write(&GET_ESN2[1],sizeof(GET_ESN2[1]));
			ct_read(&d,sizeof(d));
			esn[1]=(byte)16*(d[1]-0xC0)+(d[2]-0xB0);
			
			ct_write(&READ_MEM,sizeof(READ_MEM));
			ct_write(&GET_ESN2[2],sizeof(GET_ESN2[2]));
			ct_read(&d,sizeof(d));
			esn[2]=(byte)16*(d[1]-0xC0)+(d[2]-0xB0);
			
			ct_write(&READ_MEM,sizeof(READ_MEM));
			ct_write(&GET_ESN2[3],sizeof(GET_ESN2[3]));
			ct_read(&d,sizeof(d));
			esn[3]=(byte)16*(d[1]-0xC0)+(d[2]-0xB0);
			break;
		case ESN3:
			ct_write(&GET_ESN3[0],sizeof(GET_ESN3[0]));
			ct_read(&d,sizeof(d));
			esn[0]=(byte)16*(d[1]-0xC0)+(d[2]-0xB0);
			ct_write(&READ_MEM,sizeof(READ_MEM));
			
			ct_write(&GET_ESN3[1],sizeof(GET_ESN3[1]));
			ct_read(&d,sizeof(d));
			esn[1]=(byte)16*(d[1]-0xC0)+(d[2]-0xB0);
			
			ct_write(&READ_MEM,sizeof(READ_MEM));
			ct_write(&GET_ESN3[2],sizeof(GET_ESN3[2]));
			ct_read(&d,sizeof(d));
			esn[2]=(byte)16*(d[1]-0xC0)+(d[2]-0xB0);
			
			ct_write(&READ_MEM,sizeof(READ_MEM));
			ct_write(&GET_ESN3[3],sizeof(GET_ESN3[3]));
			ct_read(&d,sizeof(d));
			esn[3]=(byte)16*(d[1]-0xC0)+(d[2]-0xB0);
			break;
		case ESN4:
			ct_write(&GET_ESN4[0],sizeof(GET_ESN4[0]));
			ct_read(&d,sizeof(d));
			esn[0]=(byte)16*(d[1]-0xC0)+(d[2]-0xB0);
			
			ct_write(&READ_MEM,sizeof(READ_MEM));
			ct_write(&GET_ESN4[1],sizeof(GET_ESN4[1]));
			ct_read(&d,sizeof(d));
			esn[1]=(byte)16*(d[1]-0xC0)+(d[2]-0xB0);
			
			ct_write(&READ_MEM,sizeof(READ_MEM));
			ct_write(&GET_ESN4[2],sizeof(GET_ESN4[2]));
			ct_read(&d,sizeof(d));
			esn[2]=(byte)16*(d[1]-0xC0)+(d[2]-0xB0);
			
			ct_write(&READ_MEM,sizeof(READ_MEM));
			ct_write(&GET_ESN4[3],sizeof(GET_ESN4[3]));
			ct_read(&d,sizeof(d));
			esn[3]=(byte)16*(d[1]-0xC0)+(d[2]-0xB0);
			break;
		case ESN5:
			ct_write(&GET_ESN5[0],sizeof(GET_ESN5[0]));
			ct_read(&d,sizeof(d));
			esn[0]=(byte)16*(d[1]-0xC0)+(d[2]-0xB0);
			
			ct_write(&READ_MEM,sizeof(READ_MEM));
			ct_write(&GET_ESN5[1],sizeof(GET_ESN5[1]));
			ct_read(&d,sizeof(d));
			esn[1]=(byte)16*(d[1]-0xC0)+(d[2]-0xB0);
			
			ct_write(&READ_MEM,sizeof(READ_MEM));
			ct_write(&GET_ESN5[2],sizeof(GET_ESN5[2]));
			ct_read(&d,sizeof(d));
			esn[2]=(byte)16*(d[1]-0xC0)+(d[2]-0xB0);
			
			ct_write(&READ_MEM,sizeof(READ_MEM));
			ct_write(&GET_ESN5[3],sizeof(GET_ESN5[3]));
			ct_read(&d,sizeof(d));
			esn[3]=(byte)16*(d[1]-0xC0)+(d[2]-0xB0);
			break;
	}
	return TRUE;
}
//convert ESNs to values the ctek can read and send to ctek
bool writeesn(byte esn[8],byte ESN)
{
	byte WRITE_ESN1[4][6] = {{0xC1,0xFB,0xBE,0xC1,0xF8,0xBE},{0xC1,0xFB,0xBE,0xC1,0xF8,0xBF},{0xC1,0xFB,0xBE,0xC1,0xF9,0xB0},{0xC1,0xFB,0xBE,0xC1,0xF9,0xB1}};
	byte WRITE_ESN2[4][6] = {{0xC1,0xFB,0xBE,0xC1,0xF9,0xB3},{0xC1,0xFB,0xBE,0xC1,0xF9,0xB4},{0xC1,0xFB,0xBE,0xC1,0xF9,0xB5},{0xC1,0xFB,0xBE,0xC1,0xF9,0xB6}};
	byte WRITE_ESN3[4][6] = {{0xC1,0xFB,0xBE,0xC1,0xF9,0xB8},{0xC1,0xFB,0xBE,0xC1,0xF9,0xB9},{0xC1,0xFB,0xBE,0xC1,0xF9,0xBA},{0xC1,0xFB,0xBE,0xC1,0xF9,0xBB}};
	byte WRITE_ESN4[4][6] = {{0xC1,0xFB,0xBE,0xC1,0xF9,0xBD},{0xC1,0xFB,0xBE,0xC1,0xF9,0xBE},{0xC1,0xFB,0xBE,0xC1,0xF9,0xBF},{0xC1,0xFB,0xBE,0xC1,0xFA,0xB0}};
	byte WRITE_ESN5[4][6] = {{0xC1,0xFB,0xBE,0xC1,0xFA,0xB2},{0xC1,0xFB,0xBE,0xC1,0xFA,0xB3},{0xC1,0xFB,0xBE,0xC1,0xFA,0xB4},{0xC1,0xFB,0xBE,0xC1,0xFA,0xB5}};
	
	byte value[3];
	
	switch(ESN) {
		case ESN1:
			value[0]=0xC1;
			value[1]=(esn[0]+0xF0);
			value[2]=(esn[1]+0xB0);
			write_memory(WRITE_ESN1[0],value);
			value[0]=0xC1;
			value[1]=(esn[2]+0xF0);
			value[2]=(esn[3]+0xB0);
			write_memory(WRITE_ESN1[1],value);
			value[0]=0xC1;
			value[1]=(esn[4]+0xF0);
			value[2]=(esn[5]+0xB0);
			write_memory(WRITE_ESN1[2],value);
			value[0]=0xC1;
			value[1]=(esn[6]+0xF0);
			value[2]=(esn[7]+0xB0);
			write_memory(WRITE_ESN1[3],value);
			break;
		case ESN2:
			value[0]=0xC1;
			value[1]=((byte)esn[0]+0xF0);
			value[2]=((byte)esn[1]+0xB0);
			write_memory(WRITE_ESN2[0],value);
			value[0]=0xC1;
			value[1]=((byte)esn[2]+0xF0);
			value[2]=((byte)esn[3]+0xB0);
			write_memory(WRITE_ESN2[1],value);
			value[0]=0xC1;
			value[1]=((byte)esn[4]+0xF0);
			value[2]=((byte)esn[5]+0xB0);
			write_memory(WRITE_ESN2[2],value);
			value[0]=0xC1;
			value[1]=((byte)esn[6]+0xF0);
			value[2]=((byte)esn[7]+0xB0);
			write_memory(WRITE_ESN2[3],value);
			break;
		case ESN3:
			value[0]=0xC1;
			value[1]=((byte)esn[0]+0xF0);
			value[2]=((byte)esn[1]+0xB0);
			write_memory(WRITE_ESN3[0],value);
			value[0]=0xC1;
			value[1]=((byte)esn[2]+0xF0);
			value[2]=((byte)esn[3]+0xB0);
			write_memory(WRITE_ESN3[1],value);
			value[0]=0xC1;
			value[1]=((byte)esn[4]+0xF0);
			value[2]=((byte)esn[5]+0xB0);
			write_memory(WRITE_ESN3[2],value);
			value[0]=0xC1;
			value[1]=((byte)esn[6]+0xF0);
			value[2]=((byte)esn[7]+0xB0);
			write_memory(WRITE_ESN3[3],value);
			break;
		case ESN4:
			value[0]=0xC1;
			value[1]=((byte)esn[0]+0xF0);
			value[2]=((byte)esn[1]+0xB0);
			write_memory(WRITE_ESN4[0],value);
			value[0]=0xC1;
			value[1]=((byte)esn[2]+0xF0);
			value[2]=((byte)esn[3]+0xB0);
			write_memory(WRITE_ESN4[1],value);
			value[0]=0xC1;
			value[1]=((byte)esn[4]+0xF0);
			value[2]=((byte)esn[5]+0xB0);
			write_memory(WRITE_ESN4[2],value);
			value[0]=0xC1;
			value[1]=((byte)esn[6]+0xF0);
			value[2]=((byte)esn[7]+0xB0);
			write_memory(WRITE_ESN4[3],value);
			break;
		case ESN5:
			value[0]=0xC1;
			value[1]=((byte)esn[0]+0xF0);
			value[2]=((byte)esn[1]+0xB0);
			write_memory(WRITE_ESN5[0],value);
			value[0]=0xC1;
			value[1]=((byte)esn[2]+0xF0);
			value[2]=((byte)esn[3]+0xB0);
			write_memory(WRITE_ESN5[1],value);
			value[0]=0xC1;
			value[1]=((byte)esn[4]+0xF0);
			value[2]=((byte)esn[5]+0xB0);
			write_memory(WRITE_ESN5[2],value);
			value[0]=0xC1;
			value[1]=((byte)esn[6]+0xF0);
			value[2]=((byte)esn[7]+0xB0);
			write_memory(WRITE_ESN5[3],value);
			break;
	}
	return TRUE;
}

bool getesn(byte esn[4])
{
	byte GET_ESN[3] = {0xC1,0xF1,0xB8};
	
	byte d[12];
	
	ct_write(&GET_ESN,sizeof(GET_ESN));
	ct_read(&d,sizeof(d));
	
	
	esn[0]=(byte)16*(d[1]-0xC0)+(d[2]-0xB0);
	esn[1]=(byte)16*(d[4]-0xC0)+(d[5]-0xB0);
	esn[2]=(byte)16*(d[7]-0xC0)+(d[8]-0xB0);
	esn[3]=(byte)16*(d[10]-0xC0)+(d[11]-0xB0);
	return TRUE;
}
