// cteklib.h   -global unix ver. header.  Avoozl, [dOPEMan], PoTom   1998-99

//GLOBAL TYPES
typedef unsigned char byte;
typedef unsigned int word;

// OKI 900 DEFINITIONS
#define OKI_MODE_NORMAL 0x00
#define OKI_MODE_TEST 0x01
#define OKI_KEY_1 0x02
#define OKI_KEY_2 0x03
#define OKI_KEY_3 0x04
#define OKI_KEY_4 0x05
#define OKI_KEY_5 0x06
#define OKI_KEY_6 0x07
#define OKI_KEY_7 0x08
#define OKI_KEY_8 0x09
#define OKI_KEY_9 0x0A
#define OKI_KEY_0 0x0B
#define OKI_KEY_STAR 0x0C
#define OKI_KEY_POUND 0x0D
#define OKI_KEY_SND 0x0E
#define OKI_KEY_END 0x0F
#define OKI_KEY_RCL 0x10
#define OKI_KEY_STO 0x11
#define OKI_KEY_ALPH 0x12
#define OKI_KEY_MENU 0x13
#define OKI_KEY_CLR 0x14
#define OKI_KEY_UP 0x15
#define OKI_KEY_DOWN 0x16
#define OKI_KEY_RELEASE 0x17
#define OKI_AUDIO_EARPIECE 0x18
#define OKI_AUDIO_SOUNDER 0x19
#define OKI_AUDIO_EXTERNAL 0x1A
#define OKI_TONE_LOW 0x1B
#define OKI_TONE_HIGH 0x1C
#define ESN1 0x1D
#define ESN2 0x1E
#define ESN3 0x1F
#define ESN4 0x20
#define ESN5 0x21
#define OKI_FCC_SETUP 0x22
#define OKI_FCC_GET 0x23
#define OKI_FCC_ABORT 0x24
#define OKI_FVC_SETUP 0x25
#define OKI_FVC_GET 0x26
#define OKI_FVC_ABORT 0x27
#define NAM1 0x28
#define NAM2 0x29
#define NAM3 0x2A
#define NAM4 0x2B
#define NAM5 0x2C

// BOOL Workaround
#define bool ct_bool
typedef int ct_bool;
#undef TRUE
#undef FALSE
#define TRUE ((bool)1)
#define FALSE ((bool)0)

// ON/OFF switches and IN/OUT directions
#define GET ((bool)1)
#define PUT ((bool)0)
#define ON  ((bool)1)
#define OFF ((bool)0) 

//  STRUCTURES
struct nam {
	char areacode[4];
	char prefix[4];
	char number[5];
	int sid;
	char sys;
	int ipch;
	int olc;
	int gim;
} ;

struct fccval {
	int scc;
	int dcc;
	int order;
	int ordq;
	char areacode[4];
	char prefix[4];
	char number[5];
	int local;
	int chan;
	int vmac;
} ;

struct fvcval {
	int scc;
	int pscc;
	int order;
	int ordq;
	int local;
	int chan;
	int vmac;
} ;



/////////////////////////////////////////////////////////////////////////
///              FUNCTIONS DECLARATIONS                               ///
/////////////////////////////////////////////////////////////////////////

// TTY I/O routines (ttyio.c)
extern bool open_comport(const char *port);
extern void close_comport();
extern void ct_write(const void *buf, size_t count);
extern void ct_read(void *buf, size_t count);
extern void clearbuffer();
extern void alarmbreak(int signal);
extern void alarmabort(int signal);


// 4712 ESN routines (4712.c)
extern void read_esns(char *value1,char *value2, char *value3, char *value4, char *value5);
extern void write_esns(const char *msg1, const char *msg2, const char *msg3, const char *msg4, const char *msg5);
extern bool getesn(byte esn[4]);
extern bool readesn(byte esn[4],byte ESN);
extern bool writeesn(byte esn[8],byte ESN);

// NAM Stuff (cteklib.c)
extern void read_nam(struct nam *nam_info,byte NAM);
extern void write_nam(struct nam nam_info,byte NAM);
extern void write_nam_init();
extern void write_nam_finish();

// other CTEK control and utillties (cteklib.c)
extern bool initialize_oki(byte MODE);
extern void turn_off_oki();
extern void sendkey(byte KEY);
extern int checkinput(int inputval);
extern void rx_audio(bool state);			// state=TRUE/FALSE
extern void rx_audio_path(byte MODE);
extern void tx_audio(bool state);			// state=TRUE/FALSE
extern void set_comp_exp(bool state);			// state=TRUE/FALSE
extern void set_volume(int level);
extern void audio_tone(byte tone, bool state);		// state=TRUE/FALSE
extern void set_carrier(bool state);			// state=TRUE/FALSE
extern void tx_power(int level);
extern void set_sat(int sat);
extern int get_battery_level();
extern int get_rss();
extern bool get_custom_msg(char *msg);
extern void set_custom_msg(char *msg);
extern bool get_romversion(char *romver);
extern byte convert(byte first,byte second);
extern void convert_hex_twohex(byte hexcode[2], byte hex);
extern void write_memory(byte address[6],byte value[3]);
extern void break_hex(byte hexcode[2],byte hex);
extern int set_channel(int channel);
extern bool get_fcc(byte MODE,byte *stream);
extern bool decode_fcc(byte *stream,struct fccval *focc);
extern bool get_fvc(byte MODE, byte *stream);
extern bool decode_fvc(byte *stream, struct fvcval *fvc);
extern void convert_min_to_phone(int *min1, int *min2,char *min);
extern void convert_hex_bin(byte hexvalue,int *bin);
extern void decode_order(int order, int ordq, char *type);
extern int find_fcc(int carrier);
extern byte genchecksum();
extern void exitprog(int signal);
extern void loopexit(int signal);
extern int keylock_pass(bool mode, char *keyPass);	// mode=PUT/GET
extern float channel_to_ffreq(int strongfcc);

extern void ct_battery_discharge(bool swtch);		// swtch=ON/OFF
extern int dealer_pass(bool mode,char *pass);		// mode=PUT/GET
byte enc_paskey(char entry, byte mask);
extern int adm_pass(bool mode, char *pass);		// mode=PUT/GET
