/*
  Scan voice channels sequentially.  Monitor active channels.
  Print channel, frequency, and rss to screen.
*/

#include <conio.h>
#include <bios.h>
#include "scan.h"
#include "ctlib.h"

void vc_scan(int arg)
{
  static int chan;
  word (*next_chan)(word);              /* ptr to function used to set channel */
  int key;

  switch (arg)
  {
    case INIT:
      chan = 1;
      return;
    case ALT:
      next_chan = ct_dec_channel;
      break;
    default:
      next_chan = ct_inc_channel;
      break;
  }

  if (global.type == VOICE)
    chan = ct_state.channel;
  global.mode = SCAN_MODE;
  for(;;)
  {
    if (bioskey(1) != 0)                /* if keypress waiting */
    {
      key = process_key();
      if (key == BAIL)  
	break;
      if ((key == CHAN) || (key == CHAN2) || (key == SYS))
	chan = ct_state.channel;	/* go to new channel */
    }
    ct_set_channel(chan);
    update_status();
    if (ct_get_rss() >= global.squelch)
    {                                   /* if channel active */
      cprintf("channel %d\r\n",chan);
      vc_mon();                         /* monitor voice channel */
      global.mode = SCAN_MODE;          /* and then go back to scanning */
    }
    chan = (*next_chan)(chan);
  }
}
