/*
  Monitor a voice channel.  Unmute the audio and monitor messages
  on the channel.  Follow handoffs.  Quit the function on a release
  or audit (if set by user).
*/

#include <conio.h>
#include <bios.h>
#include <stdio.h>
#include "scan.h"
#include "ctlib.h"

void vc_mon()
{
  byte word1[6];
  long time;
  int scc,pscc,order,ordq,local,chan,vmac;

  global.mode = VCMON_MODE;
  time = biostime(0,0);
  ct_set_rx_audio(TRUE && !global.mute);
  update_status();
  ct_fvc_msg(MSG_SETUP,NULL);
  for (;;)
  {
    if (bioskey(1) != 0)                /* if keypress waiting */
    {
      ct_fvc_msg(MSG_ABORT,NULL);       /* then abort waiting for msg */
      if (process_key() == BAIL)        /* deal with keypress */
	break;
      update_status();
      ct_fvc_msg(MSG_SETUP,NULL);       /* wait for msgs again */
    }

    /* check the rssi.  bail if less than global.squelch */
    if ((biostime(0,0) - time) > SQU_TIME)
    {
      ct_fvc_msg(MSG_ABORT,NULL);
      if (ct_get_rss() < global.squelch)
	break;
      ct_fvc_msg(MSG_SETUP,NULL);
      time = biostime(0,0);
    }

    if (!ct_fvc_msg(MSG_GET,word1))     /* incoming msg received? */
      continue;                         /* no, keep waiting */

    /* got an order from base station, so decode it */
    if (!ct_decode_fvc_msg(word1,&scc,&pscc,&order,&ordq,&local,&chan,&vmac))
    {
      ct_fvc_msg(MSG_SETUP,NULL);       /* get ready for next msg */
      continue;                         /* ignore bad messages */
    }

    if (scc == 3)                       /* print order received */
    {
      cprintf("  order: %s scc=%d pscc=%d\r\n",ct_decode_order(order,ordq),scc,pscc);
      ct_fvc_msg(MSG_SETUP,NULL);       /* get ready for next msg */
      if ((order == 3) || ((order == 7) && global.audit))
					/* end of call if release */
      {                                 /* or if release-on-audit set */
	cprintf("  call released\r\n");
	break;
      }
      continue;
    }
    /* follow a handoff request */
    cprintf("  handoff: chan=%d vmac=%d scc=%d pscc=%d\r\n",chan,vmac,scc,pscc);
    ct_set_channel(chan);
    ct_fvc_msg(MSG_SETUP,NULL);         /* rcv next msg */
  }
  ct_fvc_msg(MSG_ABORT,NULL);
  ct_set_rx_audio(FALSE);
}
