/*
  More utility functions.
  decode_dtmf, set_squelch, set_system, set_channel, set_omni_offset
  set_numchan
*/

#include <conio.h>
#include <bios.h>
#include <stdlib.h>
#include "scan.h"
#include "ctlib.h"

char buf[BUFLEN];           /* buffers global to these functions */
char *p;

/* decode DTMF digits.  Print digits to data window until keypress */
void decode_dtmf()
{
  int digit;

  digit = ct_dtmf_decode(DTMF_DECODE_START);
  window(PROMPT);
  cprintf("Decoding DTMF.  Press any key to resume.");
  window(DATA);
  gotoxy(DATAXY);
  for(;;)
  {
    if (kbhit())
    {
      bioskey(0);
      break;
    }
    if (digit = ct_dtmf_decode(DTMF_DECODE_GET))
      cprintf("%c",digit);
  }
  ct_dtmf_decode(DTMF_DECODE_END);
  cprintf("\r\n");
  window(PROMPT);
  clrscr();
}

/* set the squelch */
void set_squelch(int arg)
{
  int num;

  switch (arg)
  {
    case ALT_SL: case ALT_SR:
      global.squelch = (global.squelch + 99) % 100;   /* subtract 1 */
      return;
    case ALT:
      global.squelch = (global.squelch + 1) % 100;    /* add 1 */
      return;
    default:
      break;
  }
  buf[0] = BUFLEN - 2;                          /* for cgets */
  window(PROMPT);
  for(;;)
  {
    clrscr();
    cprintf("Enter new squelch level (0-99): ");
    p = cgets(buf);                             /* read in as string */
    if (p[0] == '\0')                           /* bail if no entry */
      break;
    if (!(num = atoi(p)) && (p[0] != '0'))      /* convert and check */
      continue;                                 /* bad entry, try again */
    if ((num >= 0) && (num <= 99))              /* check limits */
    {
      global.squelch = num;                     /* good entry */
      break;
    }
  }
  clrscr();
}

/* Toggle the system.  Go to a channel on that system. */
void set_system()
{
  if (global.system == 'A')
  {
    global.system = 'B';
    if (global.type == VOICE)
      ct_set_channel(355);              /* first system B voice channel */
    else
      ct_set_channel(334);              /* first system B control channel */            
  }
  else
  {
    global.system = 'A';
    if (global.type == VOICE)
      ct_set_channel(1);                /* first system A voice channel */
    else
      ct_set_channel(313);              /* first system A control channel */            
  }
}

/* Prompt user for channel and go to that channel */
void set_channel(int arg)
{
  int chan;
  byte *dum1,*dum2;

  switch (arg)
  {
    case ALT_SL: case ALT_SR:                           
      if (global.type == VOICE)
	ct_set_channel(ct_dec_channel(ct_state.channel));
      else
	ct_set_channel(313 + ((ct_state.channel - 313 + 41) % 42));
      return;
    case ALT:
      if (global.type == VOICE)
	ct_set_channel(ct_inc_channel(ct_state.channel));
      else
	ct_set_channel(313 + ((ct_state.channel - 313 + 1) % 42));
      return;
    default:
      break;
  }
  buf[0] = BUFLEN - 2;                          /* for cgets */
  window(PROMPT);
  for(;;)
  {
    clrscr();
    cprintf("Enter channel (1-799, 991-1023): ");
    p = cgets(buf);                             /* read in as string */
    if (p[0] == '\0')                           /* bail if no entry */
      break;
    if (!(chan = atoi(p)))                      /* convert and check */
      continue;                                 /* bad entry, try again */
    if (ct_channel_type(chan,dum1,dum2))        /* if channel good */
    {
      ct_set_channel(chan);
      break;
    }
  }
  clrscr();
}

/* Prompt user for OMNICELL offset */
void set_omni_offset(int arg)
{
  int num;

  switch (arg)
  {
    case ALT_SL: case ALT_SR:
      global.offset = (global.offset + 20) % 21;      /* subtract 1 */
      return;
    case ALT:
      global.offset = (global.offset + 1) % 21;       /* add 1 */
      return;
    default:
      break;
  }
  buf[0] = BUFLEN - 2;                          /* for cgets */
  window(PROMPT);
  for(;;)
  {
    clrscr();
    cprintf("Enter OMNICELL offset (0-20): ");
    p = cgets(buf);                             /* read in as string */
    if (p[0] == '\0')                           /* bail if no entry */
      break;
    if (!(num = atoi(p)) && (p[0] != '0'))      /* convert and check */
      continue;                                 /* bad entry, try again */
    if ((num >= 0) && (num <= 20))
    {
      global.offset = num;
      break;
    }
  }
  clrscr();
}

/* Prompt user for number of channels to graph */
void set_numchan()
{
  int num;

  buf[0] = BUFLEN - 2;                          /* for cgets */
  window(PROMPT);
  for(;;)
  {
    clrscr();
    cprintf("Enter number of channels to graph (1-%d): ",MAX_CHAN);
    p = cgets(buf);                             /* read in as string */
    if (p[0] == '\0')                           /* bail if no entry */
      break;
    if (!(num = atoi(p)))                       /* convert and check */
      continue;                                 /* bad entry, try again */
    if ((num >= 1) && (num <= MAX_CHAN))
    {
      global.numchan = num;
      break;
    }
  }
  clrscr();
}
