/*
  Various utility functions for the scan program.
  set_vol, set_source, chan2freq, cleanup
*/

#include "scan.h"
#include "ctlib.h"

/*
 Set the volume.  inc is -1 to make it louder and 1 to make it
 quieter.  I know it's kinda backwards, so sue me!
*/
void set_vol(int inc)
{
  int vol;

  vol = (ct_state.volume + 8 + inc) % 8;      /* whoa! getting tricky... */
  ct_set_volume(vol);
}

/* Set the audio path. */
void set_source()
{
  int source;

  source = (ct_state.audiopath + 1) % 3;
  ct_set_audio_path(source);
}

/* Get frequency from channel. */
float chan2freq(int chan)
{
  if ((chan >= 1) && (chan <= 799))
    return (870.0 + (0.03 * chan));
  else if ((chan >= 990) && (chan <= 1023))
    return (870.0 + (0.03 * (chan - 1023)));
  else
    return 0.0;
}

void cleanup()
{
  ct_off();                             /* turn off phone */
  ct_lib_done();                        /* cleanup library stuff */
  window(FULLSCR);
  clrscr();                             /* clear screen */
  exit(0);                              /* bye! */
}
