/*
  Update the information in the screen status window.  Also updates
  certain global variables.  After printing info to the screen, the
  window is set to DATA.
*/

#include <conio.h>
#include "scan.h"
#include "ctlib.h"

void update_status()
{

  /* update global variables */
  global.rssi = ct_get_rss();
  ct_channel_type(ct_state.channel,&global.system,&global.type);

  /* print the stuff to the status window */
  window(STATUS);
  cprintf(" Channel: %04d  Freq.: %7.3f  RSS: %03d  Type: %c  System: %c  Stream: %4s\r\n",
	ct_state.channel,
	chan2freq(ct_state.channel),
	global.rssi,
	global.type,
	global.system,
	ct_state.stream==0 ? "EVEN" : "ODD");

  cprintf(" Audio: %6s  Volume: %d  Comp/Exp: %3s  Source: %8s  Always Mute: %c\r\n",
	ct_state.rxaudio==0 ? "MUTE" : "UNMUTE",
	ct_state.volume,
	ct_state.compexp==0 ? "OFF" : "ON",
	ct_state.audiopath==0 ? "EXTERNAL" : (ct_state.audiopath==1 ? "EARPIECE" : "SOUNDER"),
	global.mute==0 ? 'N' : 'Y');

  cprintf(" Mode: %c  OMNICELL Offset: %03d  Squelch: %03d  Release on Audit: %c \r",
	global.mode,
	global.offset,
	global.squelch,
	global.audit==0 ? 'N' : 'Y');

  window(DATA);			/* set back to data window */
  gotoxy(DATAXY);		/* put cursor at bottom of data window */
}

