/* Include file for scan project.  Include this file before ctlib.h. */
#define FALSE           0
#define TRUE            1
#define MODELEN         11
#define BUFLEN          11
#define SQU_TIME        73             /* #seconds * 18.2 */
#define VOICE           'A'
#define CONTROL         'C'

/* screen window rectangles */
#define STATUS          2,2,78,4
#define DATA            1,6,52,23
#define COMMAND         55,6,78,24
#define PROMPT          1,24,52,24
#define DATAXY          1,18
#define FULLSCR         1,1,79,24
#define GRAPH           1,3,79,24
#define GRAPHXY         1,1
#define G_STATUS	1,1,79,2


/* keypress definitions */
#define BAIL    ' '
#define ESC     0x11B
#define TAB     0x09
#define CHAN    'C'             /* set channel */
#define CHAN2   0x2e00          /* DOS keycodes are soooo lame! */
#define SYS     'S'             /* toggle system A/B */
#define SCAN    '4'             /* scan voice channels */
#define SCAN2   0x7b00          /* damn the person who created these keycodes!!! */
#define OMNI    '5'             /* scan ONMICELL channels */
#define SRC     0x4d00          /* toggle audio source */
#define VOLU    0x4800          /* increase volume */
#define VOLD    0x5000          /* decrease volume */
#define MUTE    0x4b00          /* toggle mute/unmute */
#define GMUTE   'A'             /* toggle global mute/unmute */
#define COMP    'X'             /* toggle comp/exp */
#define SQU     'Q'             /* set the squelch */
#define SQU2    0x1000          /* alt-SQU */
#define AUD     'R'             /* toggle release on audit */
#define STR     'E'             /* toggle stream even/odd */
#define VCMON   '3'             /* monitor voice channel */
#define FCMON   '2'             /* monitor forward control channel */
#define DTMF    'D'             /* decode DTMF */
#define FNDCC   'F'             /* scan for control channel */
#define OFFS    'O'             /* OMNICELL offset */
#define OFFS2   0x1800          /* alt-OFFS */
#define GRPH    '1'             /* do cool graphing stuff */

/* keypress defs for graph mode */
#define GOMNI   'M'
#define NUMCHAN 'N'

/* other graph mode stuff */
#define MAX_OMNI        16
#define MAX_CHAN        21
#define MAX_GRAPH       69              /* max graph chars we can print */
#define GRAPH_CHAR      ''
#define MAX_AVG         8               /* max samples in moving avg */

/* key modifiers */
#define ALT     0x08
#define ALT_SL  0x0A            /* alt & left shift-key */
#define ALT_SR  0x09            /* alt & right shift-key */
#define INIT    0x1000          /* used to initialize static variables */


/* global modes */
#define IDLE_MODE       'I'
#define CCMON_MODE      'C'
#define SCAN_MODE       'S'
#define VCMON_MODE      'V'
#define GRAPH_MODE      'G'

/* required by ctlib.h */
typedef unsigned char bool;
typedef unsigned char byte;
typedef unsigned int  word;

/* function prototypes */
extern void drawscreen();
extern void update_status();
extern void set_vol(int cmd);
extern void set_source();
extern float chan2freq(int chan);
extern void cleanup();
extern void cc_mon(int arg);
extern void find_cc();
extern int process_key();
extern void vc_mon();
extern void decode_dtmf();
extern void set_squelch(int arg);
extern void set_system();
extern void set_channel(int arg);
extern void vc_scan(int arg);
extern void omni_scan(int arg);
extern void set_omni_offset(int arg);
extern bool init_oki(int argc, char *argv[]);
extern void graph(int arg);

/* structure definition for global variables */
struct global_struct {
  bool  mute;                   /* always mute option */
  bool  audit;                  /* whether or not the release on audit */
  byte  system;                 /* system A or B */
  byte  type;                   /* channel type V or C */
  int   rssi;                   /* received signal strength */
  int   squelch;                /* minimum RSS to open audio */
  int   offset;                 /* offset for OMNICELL scan */
  char  mode;                   /* what the program is doing */
  int   numchan;                /* number of channels to graph */
};
extern struct global_struct global;
