/*
  Process a keypress.  If the keypress is recognized, do the specified
  function.  Otherwise, return the keypress to the calling function.
  Notice that certain keypresses are not recognized in all modes.
*/

#include <conio.h>
#include <ctype.h>

#include "scan.h"
#include "ctlib.h"

int process_key()
{
  int cmd, mod;

  mod = bioskey(2) & 0x000F;                    /* get key modifiers */
  cmd = bioskey(0);                             /* get keypress */
  if (isprint(cmd & 0x00FF))                    /* if printable ascii */
  {
    cmd = cmd & 0x00FF;                         /* get lower 8 bits */
    cmd = toupper(cmd);                         /* covert to uppercase */
  }
  switch (cmd)
  {
    case VOLU:
      set_vol(-1);
      break;
    case VOLD:
      set_vol(1);
      break;
    case MUTE:
      ct_set_rx_audio(!ct_state.rxaudio && !global.mute);
      break;
    case GMUTE:
      global.mute = !global.mute;
      ct_set_rx_audio(ct_state.rxaudio && !global.mute);
      break;
    case SRC:
      set_source();
      break;
    case STR:
      ct_stream(!ct_state.stream);
      break;
    case COMP:
      ct_set_comp_exp(!ct_state.compexp);
      break;
    case AUD:
      global.audit = !global.audit;
      break;
    case DTMF:
      decode_dtmf();
      break;
    case SQU: case SQU2:
      set_squelch(mod);
      break;
    case OFFS: case OFFS2:
      set_omni_offset(mod);
      break;
    case FNDCC:
      find_cc();
      break;
    case SYS:
      set_system();
      break;
    case CHAN: case CHAN2:
      set_channel(mod);
      break;
    case NUMCHAN:
      set_numchan();
      break;
    case ESC:
      cleanup();
      break;
    default:
      if (global.mode == IDLE_MODE)     /* only do if in IDLE mode */
      {
	switch (cmd)
	{
	  case SCAN: case SCAN2:
	    vc_scan(mod);
	    break;
	  case OMNI:
	    omni_scan(mod);
	    break;
	  case VCMON:
	    vc_mon();
	    break;
	  case FCMON:
	    cc_mon(mod);
	    break;
	  case GRPH:
	    graph(mod);
            break;
	  default:
	    break;
	}
      }
      break;
  }                             /* end of first switch */
  return cmd;
}
