
/*
  Scan OMNICELL channels for active voice channels.  If an active channel
  is found, monitor that channel.
*/

#include <conio.h>
#include <bios.h>
#include "scan.h"
#include "ctlib.h"

void init_omni_scan(); 

int chan, inc, cc;
static int prev_cc;

void omni_scan(int arg)
{
  int key;

  switch (arg)
  {
    case INIT:
      prev_cc = 313;                   /* initialize to system A */
      return;
    default:
      break;
  }
  init_omni_scan();
  global.mode = SCAN_MODE;
  for(;;)
  {
    update_status();
    if (bioskey(1) != 0)                /* if keypress waiting */
    {
      key = process_key();
      if (key == BAIL)       
	break;
      /* if (key == TAB)      */
	/* next_cc(); */
      if ((key == OFFS) || (key == OFFS2) || (key == CHAN) || (key == CHAN2))
	init_omni_scan();
      update_status();
    }
    ct_set_channel(chan);
    if (ct_get_rss() >= global.squelch)
    {                                   /* if channel active */
      cprintf("channel %d control channel %d\r\n",chan,prev_cc);
      vc_mon();                         /* monitor voice channel */
      global.mode = SCAN_MODE;          /* and then go back to scanning */
    }
    chan += inc;                        /* go to next channel */
    if ((chan < 1) || (chan > 666))     /* only scan channels in 1-666 range */
      chan = cc + inc;             
  }
  ct_set_channel(prev_cc);		/* go back to cc on exit */
}

/* set the control channel with offset, increment, and first voice channel */
void init_omni_scan()
{
  ct_channel_type(ct_state.channel,&global.system,&global.type);
  if (global.type == CONTROL)
    prev_cc = ct_state.channel;
  if (global.system == 'A')
    {
      inc = -21;                    
      cc = prev_cc - global.offset;
    }
    else
    {
      inc = 21;                                
      cc =  prev_cc + global.offset;
    }
  chan = cc + inc;                      /* set to first voice channel */
}
