/*
  Initialize the CTEK library and the OKI.  Set initial values for
  statup, such as the channel, volume, audio source, etc.
  Return TRUE if initialized, FALSE otherwise.
*/

#include <stdio.h>
#include <conio.h>
#include "scan.h"
#include "ctlib.h"

bool init_oki(int argc, char *argv[])
{
  /* initialize ct library using the specified COM port */
  if (argc > 1)
  {
    if (*argv[1] == '1')
      ct_lib_init(900,0x3f8,4);
    else if (*argv[1] == '2')
      ct_lib_init(900,0x2f8,3);
    else if (*argv[1] == '3')
      ct_lib_init(900,0x3e8,5);
    else
    {
      printf("Type 'SCAN 2' to use COM2\n");
      return FALSE;
    }
  }
  else
    ct_lib_init(900,0x3f8,4);           /* com1 by default */

  /* power up oki and tell it what mode to use */
  if (!ct_on(MODE_TEST))
  {
    printf("?No response from OKI\n");
    ct_off();                             /* turn off phone */
    ct_lib_done();                        /* cleanup library stuff */
    return FALSE;
  }

  /* set up initial channel, volume, source, etc. */
  ct_set_rx_audio(FALSE);               /* mute audio */
  ct_set_audio_path(AUDIO_EARPIECE);
  ct_set_volume(3);
  ct_set_comp_exp(FALSE);
  ct_set_channel(1);
  return TRUE;
}
