/*
  Utilities for the graph part of the program.
*/

#include <conio.h>
#include "scan.h"
#include "ctlib.h"

/* set the channels we are going to be graphing */
/* also set global.numchan when omnicell graph */
void init_chan(bool omni, word chan[MAX_CHAN])
{
  int i, inc;
  word cc;

  if (omni && (global.type == CONTROL))
  {
    if (global.system == 'A')
    {
      inc = -21;
      cc = ct_state.channel - global.offset;
    }
    else
    {
      inc = 21;                                
      cc = ct_state.channel + global.offset;
    }
    chan[0] = ct_state.channel;
    cc = cc + inc;
    i = 1;
    while ((cc > 0) && (cc < 667))
    {
      chan[i++] = cc;
      cc = cc + inc;
    }
    global.numchan = i;
  }
  else
  {
    chan[0] = ct_state.channel;
    if (global.type == CONTROL)             /* use consecutive channels */
    {
      for (i = 1; i < MAX_CHAN; i++)
	chan[i] = chan[0] + i;
    }
    else                                    /* can't use ct_inc for control channels */
    {
      for (i = 1; i < MAX_CHAN; i++)
	chan[i] = ct_inc_channel(chan[i-1]);
    }
  }
}

/* get the rss for a list of channels */
void rss_scan(int num, word chan[MAX_CHAN], int rss_chan[MAX_CHAN])
{
  int i;

  /* get rss for each channel starting at the last channel */
  /* so we end up at the first channel when we come back */
  for(i = num-1;i >= 0;i--)
  {
    ct_set_channel(chan[i]);
    rss_chan[i] = ct_get_rss();
  }                                           
}

/* calculate a moving average over m values */
void moving_avg(int m,int rows,int cols,int new_vals[],int old_vals[MAX_CHAN][MAX_AVG])
{
  int sum, i, j;

  /* shift old sample values and insert new values */
  for(j = 0;j < rows;j++)
  {
    for(i = cols-1; i > 0;i--)
      old_vals[j][i] = old_vals[j][i-1];
    old_vals[j][0] = new_vals[j];

    /* add up m old_vals and take average */
    sum = 0;
    for(i = 0;i < m;i++)
      sum += old_vals[j][i];
    new_vals[j] = sum / m;
  }
}

/* draw the graph bars */
void do_graph (int num, word chan[MAX_CHAN], int value[])
{
  int i, j;
  char buf[MAX_GRAPH + 1];

  for (i = 0;i < num;i++)
  {
    /* create graph 'bar'.  Limit bar to MAX_GRAPH length */
    for (j = 0;(j < value[i]) && (j < MAX_GRAPH);j++)
      buf[j] = GRAPH_CHAR;
    buf[j] = '\0';
    cprintf("%04d:%03d:%s\r\n",chan[i],value[i],buf);
  }
}

/* initialize a 2D array of integers */
void init_2d(int array[MAX_CHAN][MAX_AVG])
{
  int row, col;

  for(row = 0;row < MAX_CHAN;row++)
  {
    for(col = 0;col < MAX_AVG;col++)
      array[row][col] = 1;
  }
}