/*
  Graphing is cool.  Heh heh.
*/

#include <conio.h>
#include <ctype.h>
#include <bios.h>
#include "scan.h"
#include "ctlib.h"

/* declare graph functions here instead of scan.h */
void init_chan(bool omni, word chan[]);
void rss_scan(int num, word chan[], int rss_chan[]);
void moving_avg(int m,int rows,int cols,int new_vals[],int old_vals[MAX_CHAN][MAX_AVG]);
void init_2d(int array[MAX_CHAN][MAX_AVG]);
void graph_status(int avg, bool omni);

void graph(int arg)
{
  static int m;				/* length of moving average */
  static bool omni;			/* graphing omnicells or not */
  int rss_chan[MAX_CHAN];		/* array new of rssi values */
  int avg_chan[MAX_CHAN][MAX_AVG];	/* array of MAX_AVG old rssi values */
  word chan[MAX_CHAN];                  /* the channels we're graphing */
  int key;
  char screenbuf[4096];

  switch (arg)
  {
    case INIT:
      m = 4;
      omni = FALSE;
      global.numchan = MAX_CHAN;
      return;
    default:
      break;
  }
  global.mode = GRAPH_MODE;
  init_chan(omni,chan);
  init_2d(avg_chan);
  window(FULLSCR);
  gettext(FULLSCR,screenbuf);
  clrscr();
  for(;;)
  {
    graph_status(m,omni);
    if (bioskey(1) != 0)                /* if keypress waiting */
    {
      key = process_key();
      graph_status(m,omni);		/* set type and system... */
      if (key == BAIL)  
	break;
      else if (isdigit(key))
      {
	key = key - '0';
	if ((key >= 1) && (key <= MAX_AVG))
	  m = key;
      }
      else if (key == GOMNI)
      {
	omni = !omni;
	init_chan(omni,chan);
      }
      else if ((key == SYS) || (key == CHAN) || (key == CHAN2) || (key == OFFS) || (key == OFFS2) || (key == FNDCC))
	init_chan(omni,chan);
    }
    rss_scan(global.numchan,chan,rss_chan);
    moving_avg(m,global.numchan,MAX_AVG,rss_chan,avg_chan);
    clrscr();
    do_graph(global.numchan,chan,rss_chan);
  }
  /* pop the screen and stuff */
  puttext(FULLSCR,screenbuf);
}
