/* scan all control channels of a system for strongest one */

#include <conio.h>
#include "scan.h"
#include "ctlib.h"

void find_cc()
{
  int chnl, rss, tmp;
  int hi_chnl, hi_rss;
  int beg, end;

  window(PROMPT);
  cprintf("Scanning for control channel...");

  /* set lower and upper control channel numbers depending on system type */
  if (global.system == 'A')
  {
    beg = 313;
    end = 333;
  }
  else
  {
    beg = 334;
    end = 354;
  }

  /* find the control channel with the strongest signal */
  hi_rss = 0;
  for (chnl = beg; chnl <= end; chnl++)
  {
    ct_set_channel(chnl);
    /* get rss a few times to let settle */
    rss = ct_get_rss();
    while ((tmp = ct_get_rss()) > rss)
      rss = tmp;
    if (rss > hi_rss)                   /* if highest rss, remember it */
    {
      hi_rss = rss;
      hi_chnl = chnl;
    }
  }
  ct_set_channel(hi_chnl);		/* go to that channel */
  clrscr();
}
