/*
  Monitor a cellular control channel and print decoded messages.
  If a voice channel is assigned, monitor that channel.
*/

#include <conio.h>
#include <bios.h>
#include <stdio.h>
#include "scan.h"
#include "ctlib.h"


void cc_mon(int arg)
{
  byte mems[16];
  byte *min;
  int scc,dcc,order,ordq,local,chan,vmac;
  static int ps_cc;                            /* present control channel */

  switch (arg)
  {
    case INIT:
      ps_cc = 313;
      return;
    default:
      break;
  }
  if (global.type == VOICE)
    ct_set_channel(ps_cc);
  global.mode = CCMON_MODE;
  update_status();
  ct_fcc_msg(MSG_SETUP,NULL);
  for (;;)
  {
    if (bioskey(1) != 0)                /* if keypress waiting */
    {
      ct_fcc_msg(MSG_ABORT,NULL);       /* stop waiting for msgs */
      if (process_key() == BAIL)        /* deal with keypress */
	break;
      update_status();
      ct_fcc_msg(MSG_SETUP,NULL);       /* get msgs again */
    }
    if (!ct_fcc_msg(MSG_GET,mems))      /* incoming msg received? */
      continue;                         /* no, keep waiting */

    if (!ct_decode_fcc_msg(mems,&scc,&dcc,&min,&order,&ordq,&local,&chan,&vmac))
    {
      ct_fcc_msg(MSG_SETUP,NULL);
      continue;                         /* ignore invalid msgs */
    }

    /* display decoded msg (order or channel allocation) */
    /* If a channel is allocated, monitor that channel */
    if (scc == 3)
    {
      cprintf("%s %s scc=%d dcc=%d\r\n",min,ct_decode_order(order,ordq),scc,dcc);
      ct_fcc_msg(MSG_SETUP,NULL);
    }
    else
    {
      cprintf("%s chan=%d vmac=%d scc=%d dcc=%d\r\n",min,chan,vmac,scc,dcc);
      ct_fcc_msg(MSG_ABORT,NULL);       /* stop waiting for msgs */
      ps_cc = ct_state.channel;         /* store current control channel */
      ct_set_channel(chan);             /* go to handoff channel */
      /* do auto offset calculation here */
      vc_mon();                         /* monitor voice channel */
      ct_set_channel(ps_cc);            /* go back to control channel */
      global.mode = CCMON_MODE;         /* set the mode again...cheezy! */
      update_status();
      ct_fcc_msg(MSG_SETUP,NULL);       /* start waiting for msgs again */
    }
  }
  ps_cc = ct_state.channel;             /* save current cc for next time */
}
