; assembly language routines for tty servicing
; Copyright (C) 1991 by Network Wizards

; Todo:
;  After RLS or RXD interrupt, must check if THRE bit clear, 
;    cause THRE interrupt is cleared by reading IIR.
;  Should only setup for THRE interrupt when txing needed.

;[MG hack]
EOT	equ	'*'			; end of packet marker

TTY_OUT_BUF_SZ  equ 1024
PIC	equ	020h			; port of PIC
EOI	equ	020h			; end of interrupt command to PIC
RBR	equ	0			; receive regiser
THR	equ	0			; transmit hold register
IIR	equ	2			; interrupt ident register
LCR	equ	3			; line control register
MCR	equ	4			; modem control register
LSR	equ	5			; line status register
MSR	equ	6			; modem status register

;LSR bits
DR	equ	01h			; dat ready
OE	equ	02h			; overrun error
PE	equ	04h			; parity error
FE	equ	08h			; framing error
BI	equ	10h			; break interrupt
THRE	equ	20h			; transmit hold register empty
TEMT	equ	40h			; transmitter empty

;MCR bits
RTS	equ	02h			; request to send

;MSR bits
DDSR	equ	02h			; delta DSR
DDCD	equ	08h			; delta DCD
TERI	equ	04h			; trailing edge ring indicator
CTS	equ	10h			; clear to send
DSR	equ	20h			; data set ready
RI	equ	40h			; ring indicator
DCD	equ	80h			; data carrier detect

ONLINE	equ	0efh
OFFLINE	equ	0eeh
DCDON	equ	0edh
DCDOFF	equ	0ech

XON	equ	11h
XOFF	equ	13h

;code segment
_TEXT	segment	word public 'CODE'
DGROUP	group	_DATA,_BSS
	assume	cs:_TEXT,ds:DGROUP,ss:DGROUP

	even
intrs	dw	tty_modem_int
	dw	tty_tx_int
	dw	tty_rx_int
	dw	tty_rx_status

;handle interrupts from standard serial ports
ttyint:
public _tty_int
	even
_tty_int proc	far
	push	ds
	push	ax
	push	bx
	push	cx
	push	dx
	mov	ax,DGROUP
	mov	ds,ax			; setup data segment

	mov	dx,[_f_uart]	; get uart address
	add	dx,IIR			; point at interrupt id register
chkint:
	in	al,dx			; get interrupt reason
	cmp	al,1			; any interrupts pending?
	 je	eoint			; nope, done
	cbw				; zero ah
	mov	bx,ax
;routines must preserve dx
	call	cs:[intrs+bx]		; call interrupt handler
	jmp	short chkint
eoint:
	mov	al,EOI			; end of interrupt command
	out	PIC,al			; send it to the PIC
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	pop	ds
	iret
_tty_int endp

;interrupt handlers called with:
;  dx:  port address of UART IIR (must preserve)
	even
tty_modem_int	proc	near
	add	dx,MSR-IIR		; address LSR register
	in	al,dx			; get the modem status
	sub	dx,MSR-IIR		; put it back
	mov	byte ptr [_f_msr],al	   ; save new modem status
	cmp	byte ptr [_f_fchardout],0 ;hardware flow control?
	 je	nofchard
	test	al,CTS			; clear to send?
	 jnz	rxcts			; yes
	mov	byte ptr [_f_txp],0	; not clear to send, stop txing
	ret
rxcts:	cmp	byte ptr [_f_txp],0    ; are we already cts?
	 jne	nofchard		; yes, so do nothing
	mov	byte ptr [_f_txp],1	; set can tx again
	jmp	tty_tx_int		; restart transmitter
nofchard:
	ret
tty_modem_int	endp

	even
tty_tx_int	proc	near
	mov	byte ptr [_f_txing],0	 	; not waiting anymore
	cmp	byte ptr [_f_txp],0		; ok to tx?
	 je	txnomo				; no, we're fc'd.
	cmp	byte ptr [_f_rqsxoff],0		; want an xoff sent NOW?
	 jne	txxoff				; ok, go do it
	cmp	word ptr [_f_outbufcnt],0	; any chars to tx?
	 je	txnomo		        	; no, that's it.
	mov	ax,[_f_outbufptr]		; get ptr to next char to send
	push	si
	mov	si,ax
	inc	si				; update next char pointer
	cmp	si,[_f_outbufsz]
	 jb	txnowrap
	xor	si,si
txnowrap:
	mov	[_f_outbufptr],si		; save new pointer
	dec	word ptr [_f_outbufcnt]		; once less char to send
	add	ax,[_f_outbufa]			; add in buffer address
	mov	si,ax
	mov	al,[si]				; get the char
	pop	si
txchar:	sub	dx,IIR-THR			; point to tx register
	out	dx,al				; send it
	add	dx,IIR-THR			; put it back
	mov	byte ptr [_f_txing],1		; waiting for char to tx
txnomo:	ret
txxoff:	mov	byte ptr [_f_txoff],1		; remember we xoff'd this guy
	mov	byte ptr [_f_rqsxoff],0		; clear request to tx xoff
	mov	al,XOFF
	jmp	txchar				; now send an xoff
tty_tx_int	endp

	even
tty_rx_int	proc	near
	sub	dx,IIR-RBR		; address RBR register
	in	al,dx			; get the character
;	and	al,07fh			; make it ASCII
	add	dx,IIR-RBR		; put it back
;[begin MG hack]
	cmp	al,EOT			; end of packet?
	 jne	noteot			; no
	inc	[_rx_pktcnt]		; yes, count packets
noteot:
;[end MG hack]
	cmp	al,XOFF			; handle XOFF if needed
	 jbe	rx_xoff			; check any control less than XOFF
rx_nx:	mov	bx,[_bb_write]		; next position to write to
	cmp	bx,[_bb_read]		; enough space for more?
	 je	nobbspc			; nope
	mov	[bx],al			; dump char in the buf
	inc	bx			; point to next write position
	cmp	bx,[_bb_last]		; past end of buffer?
	 jb	bbnwrap			; yes, wrap it
	mov	bx,[_bb_buf]		; reset to beginning of buffer
bbnwrap:
	mov	[_bb_write],bx		; save updated write pointer
	mov	ax,[_bb_count]		; keep a count of chars received
	inc	ax
	mov	[_bb_count],ax
	cmp	ax,[_bb_hi_limit]	; buffer filling up?
	 jb	rx_done			; no
bbhi:	cmp	byte ptr [_f_fchardin],0 ; hard input fc on?
	 jne	drop_rts		; yes, handle it
	cmp	byte ptr [_f_fcsoftin],0 ; soft input fc on?
	 je	rx_done			; no
	cmp	byte ptr [_f_txing],0   ; are we txing now?
	 je	sxoff			; no
	mov	byte ptr [_f_rqsxoff],1 ; yes, so request xoff be sent next
	jmp	rx_done
sxoff:	call	txxoff			; transmit the xoff now
	ret
;drop characters on the floor
nobbspc:
	or	byte ptr [_beepreq],1	; request a beep
	inc	[_bb_ovflow]		; count overflows
	ret
rx_xoff:
	 je	rx_x1			; xoff
	cmp	al,XON			; xon?
	 jne	rx_nx			; no, continue
rx_x1:	cmp	byte ptr [_f_fcsoftout],0 ; flow control?
	 je	rx_nx			; no, continue
	mov	byte ptr [_f_txp],0	; stop transmitting
	cmp	al,XOFF			; if xoff
	 je	rx_done
	mov	byte ptr [_f_txp],1	; else resume transmitting
	jmp	tty_tx_int		; restart transmitter
drop_rts:
	add	dx,MCR-IIR		; address mcr
	in	al,dx			; get current mcr
	and	al,not RTS		; turn off RTS
	nop
	nop				; delay in case fast machine
	nop
	out	dx,al			; set it
	sub	dx,MCR-IIR		; address iir 
rx_done:	
	ret
tty_rx_int	endp


	even
tty_rx_status	proc	near
	add	dx,LSR-IIR		; address LSR register
	in	al,dx			; get the line status
	sub	dx,LSR-IIR		; put it back
rxstat:	test	al,OE			; overrun?
	 jnz	rxoe
	test	al,PE			; parity?
	 jnz	rxpe
	test	al,FE			; framing
	 jnz	rxfe
	test	al,THRE
	 jnz	rxthre 			; handle tx_int if needed	
	ret
rxoe:	inc	[_f_lsr_oe]		; count the error
	and	al,NOT OE
	jmp	rxstat
rxpe:	inc	[_f_lsr_pe]
	and	al,NOT PE
	jmp	rxstat
rxfe:	inc	[_f_lsr_fe]
	and	al,NOT FE
	jmp	rxstat
rxthre:	jmp	tty_tx_int		; handle tx_int if needed
	
tty_rx_status	endp

_TEXT	ends

;initialized data
_DATA	segment word public 'DATA'
_DATA	ends

;uninitialized data
_BSS	segment word public 'BSS'
extrn _rx_pktcnt:word			; [MG hack]
extrn _f_uart:word
extrn _f_txing:byte
extrn _f_outbufa:word
extrn _f_outbufptr:word
extrn _f_outbufsz:word
extrn _f_outbufcnt:word
extrn _bb_buf:word
extrn _bb_last:word
extrn _bb_read:word
extrn _bb_write:word
extrn _bb_count:word
extrn _bb_hi_limit:word
extrn _bb_lo_limit:word
extrn _bb_ovflow:word
extrn _beepreq:byte
extrn _f_fcsoftin:byte
extrn _f_fcsoftout:byte
extrn _f_fchardin:byte
extrn _f_fchardout:byte
extrn _f_msr:byte
extrn _f_rqsxoff:byte
extrn _f_txp:byte
extrn _f_txoff:byte
extrn _f_lsr_oe:word
extrn _f_lsr_pe:word
extrn _f_lsr_fe:word
_BSS	ends

	end
