#ifndef FALSE
#define FALSE		0
#define TRUE		1
#endif

#define OFF		FALSE
#define ON		TRUE

#define OUTBUF_DEFSZ	2048

#define	XON	0x11
#define XOFF	0x13

#define IRQ0  0x08      /* line IRQ0 maps to this interrupt vector */

/* UART MCR bits */
#define OUT1 0x04
#define OUT2 0x08

struct bpsstruct
{
  char *type;
  int  speed;
  byte hvalue;
  byte lvalue;
};

extern bool ttydebugp;

extern struct bpsstruct bps_tab[];
extern int n_bps;

/* bigbuf stuff */
extern char *bb_buf;
extern word bb_last;
extern word bb_read;
extern word bb_write;
extern word bb_count;
extern word bb_hi_limit;
extern word bb_lo_limit;
extern word bb_ovflow;

/* transmit stuff */
extern bool f_txing;
extern char *f_outbufa;
extern word f_outbufptr;
extern word f_outbuflast;
extern word f_outbufsz;
extern word f_outbufcnt;

extern word f_lsr_oe;
extern word f_lsr_pe;
extern word f_lsr_fe;
extern bool f_dsrmon;
extern byte f_msr;

/* flow control stuff */
extern bool f_txoff;		
extern bool f_txp;		
extern bool f_fcsoftin;	
extern bool f_fcsoftout;	
extern bool f_fchardin;
extern bool f_fchardout;
extern bool f_rqsxoff;

extern word f_uart;
extern byte f_irq;

/* tty.c functions *
extern void send_break();
extern tty_rx();
extern void init_interfaces();
extern void tty_init_uart();
extern void set_uart_params();
extern void ignore_line();
extern void tty_txs();
extern void tty_tx();
extern bool tty_rx();
extern void send_break();
extern void tty_init_int();
extern void init_uart_intrs();
extern void tty_undo_int();

/* ttya.asm functions */
extern void interrupt tty_int();
