/*
  OKI Test/Maintenance Program
  Copyright (C) 1993,1994 by Network Wizards
*/

#define FALSE		0
#define TRUE		1

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <string.h>
#include <time.h>
#include <dos.h>
#include <conio.h>
#include <bios.h>

#define VERSION	    "2.0(940209)"   /* major.minor(last-edit-date) */

typedef unsigned char bool;
typedef unsigned char byte;
typedef unsigned int  word;		/* 16 bits */

#include "ctlib.h"

#define BS		0x08
#define LF		0x0a
#define CR		0x0d
#define ESC		0x1B
#define TAB		0x09
#define PUP		0x0b
#define PDN		0x0a
/* bios special key codes */
#define KEY_F1        0x3b
#define KEY_F2        0x3c
#define KEY_F3        0x3d
#define KEY_F4        0x3e
#define KEY_F5        0x3f
#define KEY_F6        0x40
#define KEY_F7        0x41
#define KEY_F8        0x42
#define KEY_F9        0x43
#define KEY_F10       0x44

#define BUFLEN		128
  
#define INVERSE_VIDEO	0x70
#define NORMAL_VIDEO	0x07

#define HORIZ_LINE      '\315'
#define VERT_LINE       '\263'
#define CROSS           '\330'

/* function to position cursor on screen */
#define cursor(x,y)	gotoxy(y,x)

byte cursor_row, cursor_col;
char status_string[40];
char args[BUFLEN];
char last_file[16];

char esn[16];				/* esn in ascii hex */
int esn_man;
long esn_ser;
char romver[16];			/* rom version in ascii hex */
char dlrpwd[16];			/* dealer password */

char buf[BUFLEN];

int loop = 0;

int r1 = 5;
int channel = 333;
char chan_sys = 'A';
char chan_type = 'C';
int carrier_state = FALSE;
int sigtone_state = FALSE;
int compexp_state = TRUE;
int attenuation = 0;
int sat_state = 3;
int hilotone = 0;
int dtmftone = 0;
int tx_audio_state = FALSE;
int rx_audio_state = FALSE;
int volume = 7;
int audio_path = 2;

struct {
  byte current;				/* current value */
  byte old;				/* old value */
} adjust[32];				/* indexed by eeprom loc - ff60 */

struct {
  byte param;				/* #92 param number */
  byte index;				/* index into adjust struct */
  byte r, c;				/* row,col of display */
} setting[32];				/* index by screen display order */

char TX_CHARS[] = " 1234567890*#ABCDefghijkl";

main(argc,argv)
  int argc;
  char *argv[];
{
  int i, comport;
  byte cmd, data;
  word msg, key;

  clrscr();
  cursor(1,12);
#ifdef NW
  cputs("OKI Test Program.  Copyright (C) 1994 Network Wizards.\r\n");
#endif
#ifdef CES
  cputs("OKI Test Program.  Cellular Evaluation Systems.\r\n");
#endif
#ifdef TSS
  cputs("OKI Test Program.  Tech Support Systems.\r\n");
#endif
  if (argc > 1)
  {
    if (*argv[1] == '1')
      ct_lib_init(900,0x3f8,4);
    else if (*argv[1] == '2')
      ct_lib_init(900,0x2f8,3);
    else if (*argv[1] == '3')
      ct_lib_init(900,0x3e8,5);
    else
    {
      cputs("Type 'TEST 2' to use COM2");
      exit(0);
    }
  }
  else
    ct_lib_init(900,0x3f8,4);

  /* power up oki and tell it what we are */
  if (!ct_on(MODE_TEST))
  {
    cursor(4,1);
    cprintf("?No response from OKI.\r\n");
    cprintf("  Make sure the phone is turned OFF and\r\n");
    cprintf("  all cables are properly attached.\r\n");
    cleanup();
    exit(1);
  }

  get_esn();
  strcpy(romver,ct_get_romver());
  strcpy(dlrpwd,ct_get_prog_pwd());
  cursor(3,1);  cprintf("ESN: %s (%d-%08ld) ",esn,esn_man,esn_ser);
  cursor(3,32); cprintf("ROM: %s (%d)",romver,ct_model);
  cursor(3,51); cprintf("Dealer Password: %s",dlrpwd);
  cursor(24,1); cputs("Wait...");
#ifdef CES
  get_adjust_data();
#endif
  cursor(24,1); cputx("{ESC}   Exit");
  do_redisplay();
    
  /* main command loop */ 
  for (;;)
  {
    if (bioskey(1) != 0)		/* if keypress waiting */
    {
      key = bioskey(0);			/* read keypress codes */
      cmd = key & 0x00ff;		/* get ascii code if any */
      data = (key & 0xff00) >> 8;	/* key function code if any */
      if (cmd == ESC)
	break;
      if (isupper(cmd))
	cmd = tolower(cmd);
      if (cmd == 0)			/* if no ascii code */
      {
	switch (data)			/* convert function code to ascii */
	{
          case KEY_F1:  cmd = '1'; break;
          case KEY_F2:  cmd = '2'; break;
          case KEY_F3:  cmd = '3'; break;
          case KEY_F4:  cmd = '4'; break;
          case KEY_F5:  cmd = '5'; break;
          case KEY_F6:  cmd = '6'; break;
          case KEY_F7:  cmd = '7'; break;
          case KEY_F8:  cmd = '8'; break;
          case KEY_F9:  cmd = '9'; break;
          case KEY_F10: cmd = '0'; break;
	  default: break;
	}
      }
      switch (cmd)
      {
        case '1':  do_channel(TRUE); break;
        case '2':  do_carrier(TRUE); break;
        case '3':  do_attenuation(TRUE); break;
        case '4':  do_sigtone(TRUE); break;
        case '5':  do_sat(TRUE); break;
        case '6':  do_dtmf(TRUE); break;
        case '7':  do_compexp(TRUE); break;
        case '8':  do_hilo(TRUE); break;
#ifdef CES
        case '9':  do_adjust(TRUE); break;
#endif
        case 't':  do_txaudio(TRUE); break;
        case 'r':  do_rxaudio(TRUE); break;
        case 'o':  do_output(TRUE); break;
        case 'v':  do_volume(TRUE); break;
	default:   break;
      }
    }
    if (loop++ > 2000)
    {
      do_rss();
      loop = 0;
    }
  }
  cursor(24,1);
  cleanup();
  exit(0);
}

cleanup()
{
  ct_off();
  ct_lib_done();
}

get_esn()
{
  byte cmd, data;
  word a, b, c, d;
  unsigned long n;

  if (!ct_get_esn(&n))
    n = 0;
  sprintf(esn,"%08lX",n);
  esn_man = n >> 24;
  esn_ser = n & 0xffffff;
}

display_state(row,col,state)
  int row, col, state;
{
  cursor(row,col);
  if (state) cputs("ON "); else cputs("off");
}

display_error(msg)
  char *msg;
{
  cursor(25,1);
  cputs(msg);
  delay(2000);
  cursor(25,1);
  cputs("                                                              ");
}

do_redisplay()
{
  do_channel(FALSE);
  do_carrier(FALSE);
  do_attenuation(FALSE);
  do_sigtone(FALSE);
  do_sat(FALSE);
  do_dtmf(FALSE);
  do_compexp(FALSE);
  do_hilo(FALSE);
  do_audio();
  do_txaudio(FALSE);
  do_rxaudio(FALSE);
  do_output(FALSE);
  do_volume(FALSE);
#ifdef CES
  do_adjust(FALSE);
#endif
}

do_rss()
{
  byte cmd, rss;
      
  ct_oki_send_data(0x35);
  ct_oki_get_msg(&cmd,&rss,1000);
  cursor(4,1); cprintf("RSS: %02x (%1.2fV)",rss,rss*0.02);
}

do_channel(set)
  int set;
{
  int chan;
  float freq;
    
  if (set)
  {
    cursor(23,1); cputs("Channel? ");
    fgets(buf,BUFLEN,stdin);
    chan = atoi(buf);
    if (!ct_channel_type(chan,&chan_sys,&chan_type))
    {
      display_error("Invalid channel number");
      cursor(23,1);  cputs("                                       ");
      return;
    }
    channel = chan;
  }
  ct_set_channel(channel);
  cursor(6,1);
  cputx("{F1}: "); cprintf("Channel:           %04d",channel);
  if (channel < 800)
    freq = 0.03 * channel;
  else
    freq = 0.03 * (channel - 1023);
  cursor(4,32);
  cprintf("[ch %04d: tx %3.2f, rx %3.2f, ",channel,freq+825,freq+870);
  if (chan_type == 'A')
    cputs("voice, ");
  else
    cputs("cntrl, ");
  cprintf("Sys%c]",chan_sys);
  cursor(23,1);  cputs("                                           ");
}

do_carrier(set)
  int set;
{
  if (set)
    carrier_state ^= 1;
  ct_set_carrier(carrier_state);
  cursor(7,1); cputx("{F2}: Carrier:");
  display_state(7,24,carrier_state);
}

do_attenuation(set)
  int set;
{
  if (set)
    if (++attenuation > 7) attenuation = 0;
  ct_set_tx_power(attenuation);
  cursor(8,1); cputx("{F3}: Attenuation Level:");
  cursor(8,24); cprintf("%d ",attenuation);
}

do_sigtone(set)
  int set;
{
  if (set)
    sigtone_state ^= 1;
  ct_set_signalling_tone(sigtone_state);
  cursor(9,1); cputx("{F4}: Signalling Tone:");
  display_state(9,24,sigtone_state);
}

do_sat(set)
  int set;
{
  if (set)
    if (++sat_state > 3) sat_state = 0;
  ct_set_sat(sat_state);
  cursor(6,40); cputx("{F5}: SAT: ");
  cursor(6,65);
  if (sat_state == 0)
    cputs("5970hz  (0)");
  else if (sat_state == 1)
    cputs("6000hz  (1)");
  else if (sat_state == 2)
    cputs("6030hz  (2)");
  else if (sat_state == 3)
    cputs("off        ");
}

do_dtmf(set)
  int set;
{
  if (set)
    if (++dtmftone > 24) dtmftone = 0;
  ct_set_dtmf(dtmftone);
  cursor(7,40); cputx("{F6}: DTMF transmission:");
  cursor(7,65);
  switch (TX_CHARS[dtmftone])
  {
    case ' ': cputs("off            "); break;
    case '1': cputs("1   697+1209 hz"); break;
    case '2': cputs("2   697+1336 hz"); break;
    case '3': cputs("3   697+1477 hz"); break;
    case '4': cputs("4   770+1209 hz"); break;
    case '5': cputs("5   770+1336 hz"); break;
    case '6': cputs("6   770+1477 hz"); break;
    case '7': cputs("7   852+1209 hz"); break;
    case '8': cputs("8   852+1336 hz"); break;
    case '9': cputs("9   852+1477 hz"); break;
    case '0': cputs("0   941+1209 hz"); break;
    case '*': cputs("*   941+1336 hz"); break;
    case '#': cputs("#   941+1477 hz"); break;
    case 'A': cputs("A   697+1633 hz"); break;
    case 'B': cputs("B   770+1633 hz"); break;
    case 'C': cputs("C   852+1633 hz"); break;
    case 'D': cputs("D   941+1633 hz"); break;
    case 'e': cputs("r1  697 hz     "); break;
    case 'f': cputs("r2  770 hz     "); break;
    case 'g': cputs("r3  852 hz     "); break;
    case 'h': cputs("r4  941 hz     "); break;
    case 'i': cputs("c1  1209 hz    "); break;
    case 'j': cputs("c2  1336 hz    "); break;
    case 'k': cputs("c3  1477 hz    "); break;
    case 'l': cputs("c4  1633 hz    "); break;
    default: break;
  }
}

do_compexp(set)
  int set;
{
  if (set)
    compexp_state ^= 1;
  ct_set_comp_exp(compexp_state);
  cursor(8,40); cputx("{F7}: Compressor/Expandor:");
  display_state(8,65,compexp_state);
}

do_hilo(set)
  int set;
{
  if (set)
    if (++hilotone > 2) hilotone = 0;
  cursor(9,40); cputx("{F8}: Audio Tone:");
  cursor(9,65);
  if (hilotone == 0)
  {
    ct_set_audio_tone(TONE_LOW,FALSE);
    cputs("off          ");
  }
  else if (hilotone == 1)
  {
    ct_set_audio_tone(TONE_LOW,TRUE);
    cputs("Low (770hz)  ");
  }
  else if (hilotone == 2)
  {
    ct_set_audio_tone(TONE_HIGH,TRUE);
    cputs("High (1150hz)");
  }
}

do_audio()
{
/*  cursor(10,30); cputs("Audio Functions"); */
}

do_txaudio(set)
  int set;
{
  if (set)
    tx_audio_state ^= 1;
  ct_set_tx_audio(tx_audio_state);
  cursor(11,1); cputx(" {T}: TX Audio:");
  cursor(11,24);
  if (tx_audio_state) cputs("UnMute");
                 else cputs("Mute  ");
}

do_rxaudio(set)
  int set;
{
  if (set)
    rx_audio_state ^= 1;
  ct_set_rx_audio(rx_audio_state);
  cursor(12,1); cputx(" {R}: RX Audio:");
  cursor(12,24);
  if (rx_audio_state) cputs("UnMute");
                 else cputs("Mute  ");
}

do_output(set)
  int set;
{
  if (set)
    if (++audio_path > 2) audio_path = 0;
  cursor(11,40); cputx(" {O}: Audio Output:");
  cursor(11,65);
  if (audio_path == 0)
  {
    ct_set_audio_path(AUDIO_EXTERNAL);
    cputs("external ");
  }
  else if (audio_path == 1)
  {
    ct_set_audio_path(AUDIO_EARPIECE);
    cputs("earpiece ");
  }
  else if (audio_path == 2)
  {
    ct_set_audio_path(AUDIO_SOUNDER);
    cputs("sounder  ");
  }
}

do_volume(set)
  int set;
{
  if (set)
    if (++volume > 7) volume = 0;
  ct_set_volume(volume);
  cursor(12,40); cputx(" {V}: Volume Level:");
  cursor(12,65); cprintf("%d ",volume);
}

#ifdef CES
do_adjust(set)
  int set;
{
  byte cmd, data;
  word msg, key;
  int i, j;
  static index = 0;
  
  if (ct_model < 1150) return;
  if (!set) {display_adjust(); return; }
  cursor(15,60); cputx("{ESC to end Adjust}");
  cursor(16,60); cputx("{\032 \033 to select}");
  cursor(17,60); cputx("{\030 \031 to adjust}");
  cursor(18,60); cputx("[See OKI Tech Manual]");
  select(index,TRUE);
  for (;;)
  {
    if (bioskey(1) != 0)		/* if keypress waiting */
    {
      key = bioskey(0);			/* read keypress codes */
      cmd = key & 0x00ff;		/* get ascii code if any */
      data = (key & 0xff00) >> 8;	/* key function code if any */
      if (cmd == ESC)
	break;
      if (isupper(cmd))
	cmd = tolower(cmd);
      if (cmd == 0)			/* if no ascii code */
      {
	switch (data)			/* convert function code to ascii */
	{
	  case 0x48: cmd = 'u'; break;
	  case 0x4b: cmd = 'b'; break;
	  case 0x4d: cmd = 'f'; break;
	  case 0x50: cmd = 'd'; break;
	  default: break;
	}
      }
      switch (cmd)
      {
        case 'u':  j = setting[index].index;
		   if (adjust[j].current < 255) adjust[j].current++;
		   ct_oki_send_data(92);
		   ct_oki_send_data(setting[index].param);
		   ct_oki_send_data(adjust[j].current);
		   ct_oki_get_msg(&cmd,&data,1000);
		   if (data != adjust[j].current) beep();
		   select(index,TRUE); break;
        case 'd':  j = setting[index].index;
		   if (adjust[j].current > 0) adjust[j].current--;
		   ct_oki_send_data(92);
		   ct_oki_send_data(setting[index].param);
		   ct_oki_send_data(adjust[j].current);
		   ct_oki_get_msg(&cmd,&data,1000);
		   if (data != adjust[j].current) beep();
		   select(index,TRUE); break;
        case 'b':  select(index,FALSE);
		   if (--index < 0)  index = 15;
		   select(index,TRUE); break;
        case 'f':  select(index,FALSE);
		   if (++index > 15) index = 0;
		   select(index); break;
	default:   break;
      }
    }
    if (loop++ > 2000)
    {
      do_rss();
      loop = 0;
    }
  }
  select(index,FALSE);
  cursor(15,60); cputs("                   ");
  cursor(16,60); cputs("                   ");
  cursor(17,60); cputs("                   ");
  cursor(18,60); cputx("                     ");
}

select(i,mode)
  int i, mode;
{
  int cmp, index;
    
  index = setting[i].index;
  if (mode)
    textattr(INVERSE_VIDEO);
  else
    textattr(NORMAL_VIDEO);
  cursor(setting[i].r,setting[i].c);
  cprintf("%02x",adjust[index].current);
  cmp = adjust[index].current - adjust[index].old;
  if (cmp < 0) putch('-');
   else if (cmp > 0) putch('+');
    else putch(' ');
  textattr(NORMAL_VIDEO);
}

display_adjust()
{
  int i;
  
  cursor(14,1); cputx("{F9}:  Adjust:\r\n");
  cputs("                      Power Attenuation (dB)\r\n");
  cputs("            0     4     8    12    16    20    24    28\r\n");
  cputs("Setting:\r\n");
  cputs("\r\n");
  cputs("          DTMF  ST    SAT   -Pk   +Pk   Taud  Raud  Batt\r\n");
  cputs("          dev.  dev.  dev.  dev.  dev.  dev.  dev.  Meter\r\n");
  cputs("Setting:\r\n");
  for (i = 0; i < 16; i++)
  {
    cursor(setting[i].r,setting[i].c);
    cprintf("%02x",adjust[setting[i].index].current);
  }
}

get_adjust_data()
{
  int i;
  byte blk[32];
  
  if (ct_model < 1150) return;
  ct_read_mem(blk,0xff60,26);
  for (i = 0; i < 26; i++)
  {
    adjust[i].current = blk[i];
    adjust[i].old     = blk[i];
  }
  setting[0].param = 8;
  setting[0].index = 7;
  setting[0].r     = 17;
  setting[0].c     = 12;
  setting[1].param = 9;
  setting[1].index = 8;
  setting[1].r     = 17;
  setting[1].c     = 18;
  setting[2].param = 0x0a;
  setting[2].index = 9;
  setting[2].r     = 17;
  setting[2].c     = 24;
  setting[3].param = 0x0b;
  setting[3].index = 0x0a;
  setting[3].r     = 17;
  setting[3].c     = 30;
  setting[4].param = 0x0c;
  setting[4].index = 0x0b;
  setting[4].r     = 17;
  setting[4].c     = 36;
  setting[5].param = 0x0d;
  setting[5].index = 0x0c;
  setting[5].r     = 17;
  setting[5].c     = 42;
  setting[6].param = 0x0e;
  setting[6].index = 0x0d;
  setting[6].r     = 17;
  setting[6].c     = 48;
  setting[7].param = 0x0f;
  setting[7].index = 0x0e;
  setting[7].r     = 17;
  setting[7].c     = 54;
  setting[8].param = 3;
  setting[8].index = 1;
  setting[8].r     = 21;
  setting[8].c     = 12;
  setting[9].param = 4;
  setting[9].index = 2;
  setting[9].r     = 21;
  setting[9].c     = 18;
  setting[10].param = 5;
  setting[10].index = 3;
  setting[10].r     = 21;
  setting[10].c     = 24;
  setting[11].param = 0x11;
  setting[11].index = 0x0f;
  setting[11].r     = 21;
  setting[11].c     = 30;
  setting[12].param = 0x12;
  setting[12].index = 0x10;
  setting[12].r     = 21;
  setting[12].c     = 36;
  setting[13].param = 7;
  setting[13].index = 5;
  setting[13].r     = 21;
  setting[13].c     = 42;
  setting[14].param = 6;
  setting[14].index = 4;
  setting[14].r     = 21;
  setting[14].c     = 48;
  setting[15].param = 0x19;
  setting[15].index = 0x19;
  setting[15].r     = 21;
  setting[15].c     = 54;
}
#endif

/* display a string, highlight words in curly braces */
cputx(s)
  char *s;
{
  while (*s != '\0')
  {
    switch (*s)
    {
      case '\#': putch('\r'); putch('\n'); break;
      case '{':  textattr(INVERSE_VIDEO); break;
      case '}':  textattr(NORMAL_VIDEO); break;
      default:   putch(*s);   break;
    }
    s++;
  }
}

beep()
{
  sound(1000);
  sleep(1);
  nosound();
}