/*
  OKI Keypad Control Program
  Copyright (C) 1994 by Network Wizards
*/

#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <bios.h>
#include <ctype.h>
#include <string.h>

#define FALSE		0
#define TRUE		1

#define VERSION	        "1.4(940214)"   /* major.minor(last-edit-date) */

typedef unsigned char bool;
typedef unsigned char byte;
typedef unsigned int  word;

#include "ctlib.h"

#define BUFLEN		128
#define ESC		0x1B

char buf[BUFLEN];

main(argc,argv)
  int argc;
  char *argv[];
{
  byte cmd;
  
  /* initialize ct library using the specified COM port */
  if (argc > 1)
  {
    if (*argv[1] == '1')
      ct_lib_init(900,0x3f8,4);
    else if (*argv[1] == '2')
      ct_lib_init(900,0x2f8,3);
    else if (*argv[1] == '3')
      ct_lib_init(900,0x3e8,5);
    else
    {
      puts("Type 'TEST 2' to use COM2");
      exit(0);
    }
  }
  else
    ct_lib_init(900,0x3f8,4);		/* com1 by default */

  /* power up oki and tell it what we are */
  if (!ct_on(MODE_NORMAL))
  {
    cprintf("?No response from OKI\r\n");
    cprintf("  Make sure the phone is turned OFF and\r\n");
    cprintf("  all cables are properly attached.\r\n\n");
    cleanup();
    exit(1);
  }

  printf("Type ESCape to EXIT.\n\
 Keypresses are one of:\n\
    1  2  3\n\
    4  5  6\n\
    7  8  9\n\
    *  0  #\n\
up(+),   down(-)\n\
rcl(r),  sto(s), alph(a), menu(m)\n\
snd(d),  clr(c), end(e)\n");
		
  /* read keypresses until ESC, and act on them */
  for (;;)
  {
    if (kbhit())
    {
      cmd = tolower(getch());
      if (cmd == ESC)
	break;
      switch (cmd)
      {
        case '1': send(CT_KEY_1);     break;
        case '2': send(CT_KEY_2);     break;
        case '3': send(CT_KEY_3);     break;
        case '4': send(CT_KEY_4);     break;
        case '5': send(CT_KEY_5);     break;
        case '6': send(CT_KEY_6);     break;
        case '7': send(CT_KEY_7);     break;
        case '8': send(CT_KEY_8);     break;
        case '9': send(CT_KEY_9);     break;
        case '0': send(CT_KEY_0);     break;
        case '*': send(CT_KEY_STAR);  break;
        case '#': send(CT_KEY_POUND); break;
        case '+': send(CT_KEY_UP);    break;
        case '-': send(CT_KEY_DOWN);  break;
        case 'r': send(CT_KEY_RCL);   break;
        case 's': send(CT_KEY_STO);   break;
        case 'a': send(CT_KEY_ALPH);  break;
        case 'm': send(CT_KEY_MENU);  break;
        case 'd': send(CT_KEY_SND);   break;
        case 'e': send(CT_KEY_END);   break;
        case 'c': send(CT_KEY_CLR);   break;
	default:  break;
      }
    }
  }
  cleanup();
  exit(0);
}

cleanup()
{
  ct_off();				/* turn off phone */
  ct_lib_done();			/* cleanup library stuff */
}

/* "push" key for 100 milliseconds */
send(key)
  int key;
{
  ct_keypress(key);
  delay(100);
  ct_keypress(CT_KEY_RELEASE);
}
